/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.appium.AppiumDriverRunner;
import com.codeborne.selenide.appium.AppiumNavigator;
import com.codeborne.selenide.appium.DeepLinkLauncher;
import io.appium.java_client.AppiumDriver;
import javax.annotation.Nonnull;

public class SelenideAppium {
    private static final AppiumNavigator appiumNavigator = new AppiumNavigator();
    private static final DeepLinkLauncher deepLinkLauncher = new DeepLinkLauncher();

    public static void launchApp() {
        appiumNavigator.launchApp(() -> WebDriverRunner::getAndCheckWebDriver);
    }

    public static void openIOSDeepLink(@Nonnull String deepLinkUrl) {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            SelenideAppium.launchApp();
        }
        deepLinkLauncher.openDeepLinkOnIos((AppiumDriver)AppiumDriverRunner.getMobileDriver(), deepLinkUrl);
    }

    public static void openAndroidDeepLink(@Nonnull String deepLinkUrl, @Nonnull String appPackage) {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            SelenideAppium.launchApp();
        }
        deepLinkLauncher.openDeepLinkOnAndroid((AppiumDriver)AppiumDriverRunner.getMobileDriver(), deepLinkUrl, appPackage);
    }

    public static void terminateApp(String appId) {
        appiumNavigator.terminateApp((AppiumDriver)AppiumDriverRunner.getMobileDriver(), appId);
    }

    public static void back() {
        Selenide.back();
    }
}

