/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.appium.WebdriverUnwrapper;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.HasOnScreenKeyboard;
import java.time.Duration;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriver;
import org.slf4j.helpers.CheckReturnValue;

@ParametersAreNonnullByDefault
public class DeepLinkLauncher {
    public static Duration SAFARI_ELEMENTS_TIMEOUT = Duration.ofSeconds(30L);
    private static final String SAFARI_BUNDLE_ID = "com.apple.mobilesafari";

    public void openDeepLinkOnIos(AppiumDriver driver, String deepLinkUrl) {
        SelenideLogger.run((String)"open ios deeplink", (String)deepLinkUrl, () -> {
            HasOnScreenKeyboard keyboard = WebdriverUnwrapper.cast((WebDriver)driver, HasOnScreenKeyboard.class).orElseThrow(() -> new IllegalArgumentException("Driver doesn't support HasOnScreenKeyboard"));
            this.openSafari(driver);
            SelenideElement addressBar = Selenide.$((By)AppiumBy.iOSNsPredicateString((String)"label == 'Address' OR name == 'URL'"));
            SelenideElement urlField = Selenide.$((By)AppiumBy.iOSNsPredicateString((String)"type == 'XCUIElementTypeTextField' && name CONTAINS 'URL'"));
            if (!keyboard.isKeyboardShown()) {
                addressBar.click();
            }
            urlField.shouldBe(Condition.visible, SAFARI_ELEMENTS_TIMEOUT).setValue(deepLinkUrl + "\ue007");
            if (!this.canAutoAcceptAlerts(driver)) {
                try {
                    SelenideElement openButton = Selenide.$((By)AppiumBy.iOSNsPredicateString((String)"type == 'XCUIElementTypeButton' && name CONTAINS 'Open'"));
                    openButton.shouldBe(Condition.enabled, SAFARI_ELEMENTS_TIMEOUT).click();
                }
                catch (AssertionError assertionError) {
                    // empty catch block
                }
            }
        });
    }

    public void openDeepLinkOnAndroid(AppiumDriver driver, String deepLinkUrl, String appPackage) {
        SelenideLogger.run((String)"open android deeplink", (String)deepLinkUrl, () -> {
            ImmutableMap params = ImmutableMap.of((Object)"url", (Object)deepLinkUrl, (Object)"package", (Object)appPackage);
            driver.executeScript("mobile:deepLink", new Object[]{params});
        });
    }

    private void openSafari(AppiumDriver driver) {
        driver.executeScript("mobile:launchApp", new Object[]{ImmutableMap.of((Object)"bundleId", (Object)SAFARI_BUNDLE_ID)});
    }

    @CheckReturnValue
    private boolean canAutoAcceptAlerts(AppiumDriver driver) {
        HasCapabilities hasCapabilities = WebdriverUnwrapper.cast((WebDriver)driver, HasCapabilities.class).orElseThrow(() -> new IllegalArgumentException("Driver doesn't support HasCapabilities"));
        Capabilities capabilities = hasCapabilities.getCapabilities();
        return capabilities.is("autoAcceptAlerts");
    }
}

