/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.appium.AppiumClickOptions;
import com.codeborne.selenide.appium.WebdriverUnwrapper;
import com.codeborne.selenide.commands.Click;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.WebElementSource;
import io.appium.java_client.AppiumDriver;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.Pause;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;

@ParametersAreNonnullByDefault
public class AppiumClick
extends Click {
    @Nonnull
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        if (!WebdriverUnwrapper.isMobile(locator.driver())) {
            return super.execute(proxy, locator, args);
        }
        WebElement webElement = this.findElement(locator);
        if (args == null || args.length == 0) {
            this.click(locator.driver(), webElement);
        } else if (args.length == 1) {
            AppiumClickOptions appiumClickOptions = (AppiumClickOptions)((Object)Util.firstOf((Object[])args));
            this.click(locator.driver(), webElement, appiumClickOptions);
        } else {
            throw new IllegalArgumentException("Unsupported click arguments: " + Arrays.toString(args));
        }
        return proxy;
    }

    protected void click(Driver driver, WebElement webElement, AppiumClickOptions appiumClickOptions) {
        switch (appiumClickOptions.appiumClickMethod()) {
            case TAP_WITH_OFFSET: {
                this.performTapWithOffset(driver, webElement, appiumClickOptions.offsetX(), appiumClickOptions.offsetY());
                break;
            }
            case TAP: {
                this.performTapWithOffset(driver, webElement, 0, 0);
                break;
            }
            case DOUBLE_TAP: {
                this.performDoubleTap(driver, webElement);
                break;
            }
            case LONG_PRESS: {
                this.performLongPress(driver, webElement);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown click option: " + (Object)((Object)appiumClickOptions.appiumClickMethod()));
            }
        }
    }

    private void performLongPress(Driver driver, WebElement webElement) {
        new Actions(driver.getWebDriver()).clickAndHold(webElement).perform();
    }

    private void performDoubleTap(Driver driver, WebElement webElement) {
        Point size = webElement.getLocation();
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger1");
        Sequence doubleTapSequence = this.getSequenceToPerformTap(finger, size, 0, 0).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(40L))).addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(200L))).addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        this.perform(driver, doubleTapSequence);
    }

    private void performTapWithOffset(Driver driver, WebElement webElement, int offsetX, int offsetY) {
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger1");
        Point size = this.getCenter(webElement);
        Sequence tapSequence = this.getSequenceToPerformTap(finger, size, offsetX, offsetY);
        this.perform(driver, tapSequence);
    }

    private void perform(Driver driver, Sequence sequence) {
        WebDriver webDriver = driver.getWebDriver();
        AppiumDriver appiumDriver = WebdriverUnwrapper.cast(webDriver, AppiumDriver.class).orElseThrow(() -> new IllegalStateException("Not a mobile webdriver: " + webDriver));
        appiumDriver.perform(Collections.singletonList(sequence));
    }

    private Sequence getSequenceToPerformTap(PointerInput finger, Point size, int offsetX, int offsetY) {
        return new Sequence((InputSource)finger, 1).addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), size.getX() + offsetX, size.getY() + offsetY)).addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(200L))).addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Point getCenter(WebElement element) {
        int x = element.getLocation().getX() + element.getSize().getWidth() / 2;
        int y = element.getLocation().getY() + element.getSize().getHeight() / 2;
        return new Point(x, y);
    }

    @Nonnull
    @CheckReturnValue
    protected WebElement findElement(WebElementSource locator) {
        if (WebdriverUnwrapper.isMobile(locator.driver())) {
            return locator.getWebElement();
        }
        return super.findElement(locator);
    }
}

