/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.appium.AppiumScrollCoordinates;
import com.codeborne.selenide.appium.AppiumScrollOptions;
import com.codeborne.selenide.appium.ScrollDirection;
import com.codeborne.selenide.appium.WebdriverUnwrapper;
import com.codeborne.selenide.commands.ScrollTo;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.WebElementSource;
import io.appium.java_client.AppiumDriver;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;

@ParametersAreNonnullByDefault
public class AppiumScrollTo
implements Command<SelenideElement> {
    private static final AppiumScrollOptions DEFAULT_OPTIONS = AppiumScrollOptions.with(ScrollDirection.DOWN, 30);
    private final ScrollTo webImplementation = new ScrollTo();

    @Nonnull
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        AppiumScrollOptions scrollOptions = this.extractOptions(args);
        Optional<AppiumDriver> driver = WebdriverUnwrapper.cast(locator.driver(), AppiumDriver.class);
        if (!driver.isPresent()) {
            this.scrollInWebBrowser(proxy, locator, args, scrollOptions);
        } else {
            this.scrollInMobile(driver.get(), locator, scrollOptions);
        }
        return proxy;
    }

    @Nonnull
    @CheckReturnValue
    private AppiumScrollOptions extractOptions(@Nullable Object[] args) {
        if (args == null || args.length == 0) {
            return DEFAULT_OPTIONS;
        }
        if (args.length == 1) {
            return (AppiumScrollOptions)Util.firstOf((Object[])args);
        }
        throw new IllegalArgumentException("Unsupported scroll arguments: " + Arrays.toString(args));
    }

    private void scrollInWebBrowser(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args, AppiumScrollOptions appiumScrollOptions) {
        if (appiumScrollOptions != DEFAULT_OPTIONS) {
            throw new IllegalArgumentException("Scrolling with options is only supported for mobile drivers");
        }
        this.webImplementation.execute(proxy, locator, args);
    }

    private void scrollInMobile(AppiumDriver appiumDriver, WebElementSource locator, AppiumScrollOptions scrollOptions) {
        int currentSwipeCount = 0;
        String previousPageSource = "";
        while (this.isElementNotDisplayed(locator) && this.isNotEndOfPage(appiumDriver, previousPageSource) && this.isLessThanMaxSwipeCount(currentSwipeCount, scrollOptions.getMaxSwipeCounts())) {
            previousPageSource = appiumDriver.getPageSource();
            this.performScroll(appiumDriver, scrollOptions.getScrollDirection());
            ++currentSwipeCount;
        }
    }

    private boolean isLessThanMaxSwipeCount(int currentSwipeCount, int maxSwipeCounts) {
        return currentSwipeCount < maxSwipeCounts;
    }

    private boolean isElementNotDisplayed(WebElementSource locator) {
        try {
            return !locator.getWebElement().isDisplayed();
        }
        catch (NoSuchElementException noSuchElementException) {
            return true;
        }
    }

    private boolean isNotEndOfPage(AppiumDriver appiumDriver, String initialPageSource) {
        return !initialPageSource.equals(appiumDriver.getPageSource());
    }

    private Dimension getMobileDeviceSize(AppiumDriver appiumDriver) {
        return appiumDriver.manage().window().getSize();
    }

    private void performScroll(AppiumDriver appiumDriver, ScrollDirection scrollDirection) {
        Dimension size = this.getMobileDeviceSize(appiumDriver);
        AppiumScrollCoordinates scrollCoordinates = this.getScrollCoordinates(scrollDirection, size);
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
        Sequence sequenceToPerformScroll = this.getSequenceToPerformScroll(finger, scrollCoordinates);
        appiumDriver.perform(Collections.singletonList(sequenceToPerformScroll));
    }

    private AppiumScrollCoordinates getScrollCoordinates(ScrollDirection scrollDirection, Dimension size) {
        if (scrollDirection == ScrollDirection.UP) {
            return new AppiumScrollCoordinates(size.getWidth() / 2, (int)((double)size.getHeight() * 0.25), size.getWidth() / 2, size.getHeight() / 2);
        }
        return new AppiumScrollCoordinates(size.getWidth() / 2, size.getHeight() / 2, size.getWidth() / 2, (int)((double)size.getHeight() * 0.25));
    }

    private Sequence getSequenceToPerformScroll(PointerInput finger, AppiumScrollCoordinates scrollCoordinates) {
        return new Sequence((InputSource)finger, 1).addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), scrollCoordinates.getStartX(), scrollCoordinates.getStartY())).addAction(finger.createPointerDown(PointerInput.MouseButton.MIDDLE.asArg())).addAction(finger.createPointerMove(Duration.ofMillis(200L), PointerInput.Origin.viewport(), scrollCoordinates.getEndX(), scrollCoordinates.getEndY())).addAction(finger.createPointerUp(PointerInput.MouseButton.MIDDLE.asArg()));
    }
}

