/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.appium.WebdriverUnwrapper;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import javax.annotation.Nonnull;
import org.openqa.selenium.SearchContext;
import org.slf4j.helpers.CheckReturnValue;

public class AppiumDriverRunner {
    @Nonnull
    @CheckReturnValue
    public static AndroidDriver getAndroidDriver() {
        return WebdriverUnwrapper.cast((SearchContext)WebDriverRunner.getWebDriver(), AndroidDriver.class).orElseThrow(() -> new ClassCastException("WebDriver cannot be casted to AndroidDriver"));
    }

    @Nonnull
    @CheckReturnValue
    public static IOSDriver getIosDriver() {
        return WebdriverUnwrapper.cast((SearchContext)WebDriverRunner.getWebDriver(), IOSDriver.class).orElseThrow(() -> new ClassCastException("WebDriver cannot be casted to IosDriver"));
    }

    @Nonnull
    @CheckReturnValue
    public static <T extends AppiumDriver> T getMobileDriver() {
        if (AppiumDriverRunner.isAndroidDriver() || AppiumDriverRunner.isIosDriver()) {
            return (T)(AppiumDriverRunner.isAndroidDriver() ? AppiumDriverRunner.getAndroidDriver() : AppiumDriverRunner.getIosDriver());
        }
        throw new ClassCastException("WebDriver is not instance of AndroidDriver or IOSDriver: " + WebDriverRunner.getWebDriver());
    }

    @CheckReturnValue
    public static boolean isAndroidDriver() {
        return WebdriverUnwrapper.instanceOf((SearchContext)WebDriverRunner.getWebDriver(), AndroidDriver.class);
    }

    @CheckReturnValue
    public static boolean isIosDriver() {
        return WebdriverUnwrapper.instanceOf((SearchContext)WebDriverRunner.getWebDriver(), IOSDriver.class);
    }
}

