/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.appium.conditions.CombinedAttribute;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class AttributeWithValue
extends Condition {
    private final CombinedAttribute attribute;
    protected final String expectedAttributeValue;

    public AttributeWithValue(CombinedAttribute attribute, String expectedAttributeValue) {
        super(String.format("attribute %s=\"%s\"", attribute, expectedAttributeValue));
        this.attribute = attribute;
        this.expectedAttributeValue = expectedAttributeValue;
    }

    @Nonnull
    public CheckResult check(Driver driver, WebElement element) {
        String attributeValue = this.attribute.getAttributeValue(driver, element);
        return new CheckResult(this.expectedAttributeValue.equals(attributeValue), (Object)String.format("%s=\"%s\"", this.attribute, attributeValue));
    }
}

