/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.appium.ScrollDirection;

public class AppiumScrollOptions {
    private final ScrollDirection scrollDirection;
    private final int maxSwipeCounts;
    private static final int DEFAULT_MAX_SWIPE_COUNTS = 30;

    private AppiumScrollOptions(ScrollDirection scrollDirection, int maxSwipeCounts) {
        this.scrollDirection = scrollDirection;
        this.maxSwipeCounts = maxSwipeCounts;
    }

    public static AppiumScrollOptions with(ScrollDirection scrollDirection, int maxSwipeCounts) {
        return new AppiumScrollOptions(scrollDirection, maxSwipeCounts);
    }

    public static AppiumScrollOptions down() {
        return new AppiumScrollOptions(ScrollDirection.DOWN, 30);
    }

    public static AppiumScrollOptions down(int maxSwipeCounts) {
        return new AppiumScrollOptions(ScrollDirection.DOWN, maxSwipeCounts);
    }

    public static AppiumScrollOptions up() {
        return new AppiumScrollOptions(ScrollDirection.UP, 30);
    }

    public static AppiumScrollOptions up(int maxSwipeCounts) {
        return new AppiumScrollOptions(ScrollDirection.UP, maxSwipeCounts);
    }

    public int getMaxSwipeCounts() {
        return this.maxSwipeCounts;
    }

    public ScrollDirection getScrollDirection() {
        return this.scrollDirection;
    }
}

