/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.ClickMethod;
import com.codeborne.selenide.ClickOptions;
import com.codeborne.selenide.Command;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.appium.WebdriverUnwrapper;
import com.codeborne.selenide.commands.DoubleClick;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.IOException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class AppiumDoubleClick
implements Command<SelenideElement> {
    private final DoubleClick defaultDoubleClick = new DoubleClick();

    @Nonnull
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) throws IOException {
        if (!WebdriverUnwrapper.isMobile(locator.driver())) {
            return this.defaultDoubleClick.execute(proxy, locator, args);
        }
        Driver driver = locator.driver();
        WebElement webElement = this.findElement(locator);
        ClickOptions clickOptions = this.options(args);
        if (clickOptions.clickMethod() == ClickMethod.JS) {
            throw new UnsupportedOperationException("Click using JavaScript is not supported in mobile");
        }
        if (clickOptions.timeout() != null) {
            throw new UnsupportedOperationException("Click timeout is not supported in mobile");
        }
        driver.actions().doubleClick(webElement);
        return proxy;
    }

    private ClickOptions options(@Nullable Object[] args) {
        return args == null || args.length == 0 ? ClickOptions.usingDefaultMethod() : (ClickOptions)Util.firstOf((Object[])args);
    }

    @Nonnull
    @CheckReturnValue
    protected WebElement findElement(WebElementSource locator) {
        return locator.getWebElement();
    }
}

