/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.appium.conditions.CombinedAttribute;
import com.codeborne.selenide.collections.ExactTexts;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class AppiumAttributeValues
extends ExactTexts {
    protected final CombinedAttribute attribute;

    public AppiumAttributeValues(CombinedAttribute attribute, String ... expectedAttributeValues) {
        super(expectedAttributeValues);
        this.attribute = attribute;
    }

    public AppiumAttributeValues(CombinedAttribute attribute, List<String> expectedAttributeValues) {
        super(expectedAttributeValues);
        this.attribute = attribute;
    }

    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, List<WebElement> elements) {
        if (elements.size() != this.expectedTexts.size()) {
            return new CheckResult(CheckResult.Verdict.REJECT, (Object)elements.size());
        }
        List<String> actualAttributeValues = this.getActualAttributes(driver, elements);
        for (int i = 0; i < this.expectedTexts.size(); ++i) {
            String actualAttributeValue;
            String expectedText = (String)this.expectedTexts.get(i);
            if (Objects.equals(expectedText, actualAttributeValue = actualAttributeValues.get(i))) continue;
            return new CheckResult(CheckResult.Verdict.REJECT, actualAttributeValues);
        }
        return new CheckResult(CheckResult.Verdict.ACCEPT, null);
    }

    private List<String> getActualAttributes(Driver driver, List<WebElement> elements) {
        return elements.stream().map(element -> this.attribute.getAttributeValue(driver, (WebElement)element)).collect(Collectors.toList());
    }
}

