/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.appium.AppiumSwipeDirection;

public class AppiumSwipeOptions {
    private final AppiumSwipeDirection appiumSwipeDirection;
    private final int maxSwipeCounts;
    private static final int DEFAULT_MAX_SWIPE_COUNTS = 30;

    private AppiumSwipeOptions(AppiumSwipeDirection appiumSwipeDirection, int maxSwipeCounts) {
        this.appiumSwipeDirection = appiumSwipeDirection;
        this.maxSwipeCounts = maxSwipeCounts;
    }

    public static AppiumSwipeOptions with(AppiumSwipeDirection appiumSwipeDirection, int maxSwipeCounts) {
        return new AppiumSwipeOptions(appiumSwipeDirection, maxSwipeCounts);
    }

    public static AppiumSwipeOptions right(int maxSwipeCounts) {
        return new AppiumSwipeOptions(AppiumSwipeDirection.RIGHT, maxSwipeCounts);
    }

    public static AppiumSwipeOptions right() {
        return new AppiumSwipeOptions(AppiumSwipeDirection.RIGHT, 30);
    }

    public static AppiumSwipeOptions left(int maxSwipeCounts) {
        return new AppiumSwipeOptions(AppiumSwipeDirection.LEFT, maxSwipeCounts);
    }

    public static AppiumSwipeOptions left() {
        return new AppiumSwipeOptions(AppiumSwipeDirection.LEFT, 30);
    }

    public int getMaxSwipeCounts() {
        return this.maxSwipeCounts;
    }

    public AppiumSwipeDirection getAppiumSwipeDirection() {
        return this.appiumSwipeDirection;
    }
}

