/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.appium.SelenideAppiumElement;
import com.codeborne.selenide.appium.WebdriverUnwrapper;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.LazyWebElementSnapshot;
import com.codeborne.selenide.impl.SelenidePageFactory;
import com.codeborne.selenide.impl.WebElementSource;
import io.appium.java_client.HasBrowserCheck;
import io.appium.java_client.pagefactory.AppiumFieldDecorator;
import io.appium.java_client.pagefactory.DefaultElementByBuilder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ByIdOrName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SelenideAppiumPageFactory
extends SelenidePageFactory {
    private static final Logger logger = LoggerFactory.getLogger(SelenideAppiumPageFactory.class);

    @Nonnull
    protected By findSelector(Driver driver, Field field) {
        DefaultElementByBuilder builder = this.byBuilder(driver);
        builder.setAnnotated((AnnotatedElement)field);
        By selector = builder.buildBy();
        return selector != null ? selector : super.findSelector(driver, field);
    }

    private DefaultElementByBuilder byBuilder(Driver driver) {
        Optional<HasBrowserCheck> hasBrowserCheck = WebdriverUnwrapper.cast(driver, HasBrowserCheck.class);
        if (hasBrowserCheck.isPresent() && hasBrowserCheck.get().isBrowser()) {
            return new DefaultElementByBuilder(null, null);
        }
        Optional<HasCapabilities> hasCapabilities = WebdriverUnwrapper.cast(driver, HasCapabilities.class);
        if (hasCapabilities.isPresent()) {
            Capabilities d = hasCapabilities.get().getCapabilities();
            String platform = String.valueOf(d.getPlatformName());
            String automationName = String.valueOf(d.getCapability("automationName"));
            return new DefaultElementByBuilder(platform, automationName);
        }
        return new DefaultElementByBuilder(null, null);
    }

    @CheckReturnValue
    @Nullable
    public Object decorate(ClassLoader loader, Driver driver, @Nullable WebElementSource searchContext, Field field, By selector, Type[] genericTypes) {
        if (selector instanceof ByIdOrName) {
            return this.decorateWithAppium(loader, searchContext, field);
        }
        return super.decorate(loader, driver, searchContext, field, selector, genericTypes);
    }

    private Object decorateWithAppium(ClassLoader loader, @Nullable WebElementSource searchContext, Field field) {
        if (searchContext == null) {
            logger.warn("Cannot initialize field {}", (Object)field);
            return null;
        }
        AppiumFieldDecorator defaultAppiumFieldDecorator = new AppiumFieldDecorator((SearchContext)searchContext.getWebElement(), Duration.ZERO);
        Object appiumElement = defaultAppiumFieldDecorator.decorate(loader, field);
        if (appiumElement instanceof WebElement) {
            return Selenide.$((WebElement)((WebElement)appiumElement));
        }
        return appiumElement;
    }

    @Nonnull
    protected SelenideElement decorateWebElement(Driver driver, @Nullable WebElementSource searchContext, By selector, Field field, @Nullable String alias) {
        return this.shouldCache(field) ? LazyWebElementSnapshot.wrap((WebElementSource)new ElementFinder(driver, searchContext, selector, 0, alias)) : ElementFinder.wrap((Driver)driver, SelenideAppiumElement.class, (WebElementSource)searchContext, (By)selector, (int)0, (String)alias);
    }
}

