/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.appium.AppiumScrollCoordinates;
import com.codeborne.selenide.appium.AppiumSwipeDirection;
import com.codeborne.selenide.appium.AppiumSwipeOptions;
import com.codeborne.selenide.appium.WebdriverUnwrapper;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.WebElementSource;
import io.appium.java_client.AppiumDriver;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;

public class AppiumSwipeTo
implements Command<SelenideElement> {
    private static final AppiumSwipeOptions DEFAULT_OPTIONS = AppiumSwipeOptions.right();

    @Nullable
    public SelenideElement execute(SelenideElement element, WebElementSource locator, @Nullable Object[] args) throws IOException {
        AppiumSwipeOptions appiumSwipeOptions = this.extractOptions(args);
        Optional<AppiumDriver> driver = WebdriverUnwrapper.cast(locator.driver(), AppiumDriver.class);
        if (!driver.isPresent()) {
            throw new IllegalArgumentException("Swipe is supported only in Appium");
        }
        this.swipeInMobile(driver.get(), locator, appiumSwipeOptions);
        return null;
    }

    private void swipeInMobile(AppiumDriver appiumDriver, WebElementSource locator, AppiumSwipeOptions appiumSwipeOptions) {
        int currentSwipeCount = 0;
        while (this.isElementNotDisplayed(locator) && this.isLessThanMaxSwipeCount(currentSwipeCount, appiumSwipeOptions.getMaxSwipeCounts())) {
            this.performSwipe(appiumDriver, appiumSwipeOptions.getAppiumSwipeDirection());
            ++currentSwipeCount;
        }
    }

    private boolean isLessThanMaxSwipeCount(int currentSwipeCount, int maxSwipeCounts) {
        return currentSwipeCount < maxSwipeCounts;
    }

    private boolean isElementNotDisplayed(WebElementSource locator) {
        try {
            return !locator.getWebElement().isDisplayed();
        }
        catch (NoSuchElementException noSuchElementException) {
            return true;
        }
    }

    private Dimension getMobileDeviceSize(AppiumDriver appiumDriver) {
        return appiumDriver.manage().window().getSize();
    }

    private void performSwipe(AppiumDriver appiumDriver, AppiumSwipeDirection swipeDirection) {
        Dimension size = this.getMobileDeviceSize(appiumDriver);
        AppiumScrollCoordinates scrollCoordinates = this.getScrollCoordinates(swipeDirection, size);
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
        Sequence sequenceToPerformScroll = this.getSequenceToPerformSwipe(finger, scrollCoordinates);
        appiumDriver.perform(Collections.singletonList(sequenceToPerformScroll));
    }

    private AppiumScrollCoordinates getScrollCoordinates(AppiumSwipeDirection swipeDirection, Dimension size) {
        if (swipeDirection == AppiumSwipeDirection.RIGHT) {
            return new AppiumScrollCoordinates((int)((double)size.getWidth() * 0.75), size.getHeight() / 2, (int)((double)size.getWidth() * 0.25), size.getHeight() / 2);
        }
        return new AppiumScrollCoordinates((int)((double)size.getWidth() * 0.25), size.getHeight() / 2, (int)((double)size.getWidth() * 0.75), size.getHeight() / 2);
    }

    private Sequence getSequenceToPerformSwipe(PointerInput finger, AppiumScrollCoordinates scrollCoordinates) {
        return new Sequence((InputSource)finger, 1).addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), scrollCoordinates.getStartX(), scrollCoordinates.getStartY())).addAction(finger.createPointerDown(PointerInput.MouseButton.MIDDLE.asArg())).addAction(finger.createPointerMove(Duration.ofMillis(200L), PointerInput.Origin.viewport(), scrollCoordinates.getEndX(), scrollCoordinates.getEndY())).addAction(finger.createPointerUp(PointerInput.MouseButton.MIDDLE.asArg()));
    }

    @Nonnull
    @CheckReturnValue
    private AppiumSwipeOptions extractOptions(@Nullable Object[] args) {
        if (args == null || args.length == 0) {
            return DEFAULT_OPTIONS;
        }
        if (args.length == 1) {
            return (AppiumSwipeOptions)Util.firstOf((Object[])args);
        }
        throw new IllegalArgumentException("Unsupported swipe arguments: " + Arrays.toString(args));
    }
}

