/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Driver;
import io.appium.java_client.AppiumDriver;
import java.util.Optional;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;

public class WebdriverUnwrapper {
    public static boolean isMobile(Driver driver) {
        return WebdriverUnwrapper.instanceOf(driver, AppiumDriver.class);
    }

    public static boolean isMobile(SearchContext driver) {
        return WebdriverUnwrapper.instanceOf(driver, AppiumDriver.class);
    }

    public static <T> boolean instanceOf(Driver driver, Class<T> klass) {
        return WebdriverUnwrapper.cast(driver, klass).isPresent();
    }

    public static <T> boolean instanceOf(SearchContext driver, Class<T> klass) {
        return WebdriverUnwrapper.cast(driver, klass).isPresent();
    }

    public static <T> Optional<T> cast(Driver driver, Class<T> klass) {
        return WebdriverUnwrapper.cast((SearchContext)driver.getWebDriver(), klass);
    }

    public static <T> Optional<T> cast(SearchContext driverOrElement, Class<T> klass) {
        SearchContext unwrappedWebdriver = driverOrElement;
        while (unwrappedWebdriver instanceof WrapsDriver) {
            WrapsDriver wrapper = (WrapsDriver)unwrappedWebdriver;
            unwrappedWebdriver = wrapper.getWrappedDriver();
        }
        return klass.isAssignableFrom(unwrappedWebdriver.getClass()) ? Optional.of(unwrappedWebdriver) : Optional.empty();
    }

    public static <T> T cast(WebElement probablyWrappedWebElement, Class<T> klass) {
        WebElement unwrappedWebElement = probablyWrappedWebElement;
        while (unwrappedWebElement instanceof WrapsElement) {
            WrapsElement wrapper = (WrapsElement)unwrappedWebElement;
            unwrappedWebElement = wrapper.getWrappedElement();
        }
        if (!klass.isAssignableFrom(unwrappedWebElement.getClass())) {
            throw new IllegalArgumentException("WebElement " + unwrappedWebElement + " is not instance of " + klass.getName());
        }
        return (T)unwrappedWebElement;
    }
}

