/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.TypeOptions;
import com.codeborne.selenide.appium.AppiumDriverRunner;
import com.codeborne.selenide.appium.WebdriverUnwrapper;
import com.codeborne.selenide.appium.commands.AppiumClear;
import com.codeborne.selenide.commands.Clear;
import com.codeborne.selenide.commands.Type;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

@ParametersAreNonnullByDefault
public class AppiumType
extends Type {
    public AppiumType() {
        super((Clear)new AppiumClear());
    }

    @Nullable
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, Object[] args) {
        TypeOptions typeOptions = this.extractOptions(Objects.requireNonNull(args));
        this.clearField(proxy, locator, typeOptions);
        WebElement element = this.findElement(locator);
        this.typeIntoField(locator, element, typeOptions);
        return proxy;
    }

    private void typeIntoField(WebElementSource locator, WebElement element, TypeOptions typeOptions) {
        Actions actions = new Actions(locator.driver().getWebDriver());
        for (int i = 0; i < typeOptions.textToType().length(); ++i) {
            CharSequence character = typeOptions.textToType().subSequence(i, i + 1);
            if (AppiumDriverRunner.isAndroidDriver()) {
                element.click();
                actions.sendKeys(new CharSequence[]{character}).perform();
            } else {
                element.sendKeys(new CharSequence[]{character});
            }
            Stopwatch.sleepAtLeast((long)typeOptions.timeDelay().toMillis());
        }
    }

    @Nonnull
    @CheckReturnValue
    protected WebElement findElement(WebElementSource locator) {
        return WebdriverUnwrapper.isMobile(locator.driver()) ? locator.findAndAssertElementIsInteractable() : super.findElement(locator);
    }
}

