/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.selector;

import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.appium.WebdriverUnwrapper;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class CombinedBy
extends By {
    @Nullable
    private final By androidSelector;
    @Nullable
    private final By iosSelector;

    private CombinedBy(@Nullable By androidSelector, @Nullable By iosSelector) {
        this.androidSelector = androidSelector;
        this.iosSelector = iosSelector;
    }

    public static CombinedBy android(By android) {
        return new CombinedBy(android, null);
    }

    public CombinedBy ios(By ios) {
        return new CombinedBy(this.androidSelector, ios);
    }

    public WebElement findElement(SearchContext context) {
        return this.chooseSelector(context).findElement(context);
    }

    public List<WebElement> findElements(SearchContext context) {
        return this.chooseSelector(context).findElements(context);
    }

    private By chooseSelector(SearchContext context) {
        if (WebdriverUnwrapper.instanceOf(context, AndroidDriver.class)) {
            return Objects.requireNonNull(this.androidSelector, "Android selector not given");
        }
        if (WebdriverUnwrapper.instanceOf(context, IOSDriver.class)) {
            return Objects.requireNonNull(this.iosSelector, "iOS selector not given");
        }
        throw new UnsupportedOperationException("Unsupported webdriver: " + WebDriverRunner.getWebDriver());
    }

    public String toString() {
        if (this.androidSelector != null && this.iosSelector != null) {
            return String.format("[android:%s, ios:%s]", this.androidSelector, this.iosSelector);
        }
        if (this.androidSelector != null) {
            return this.androidSelector.toString();
        }
        if (this.iosSelector != null) {
            return this.iosSelector.toString();
        }
        return "CombinedBy: null";
    }
}

