/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.DefaultClipboard;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import io.appium.java_client.clipboard.HasClipboard;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;

public class AppiumClipboard
implements Clipboard {
    private final Driver driver;
    private final Clipboard defaultClipboard;

    public AppiumClipboard(Driver driver) {
        this.driver = driver;
        this.defaultClipboard = new DefaultClipboard(driver);
    }

    public Driver driver() {
        return this.driver;
    }

    public Clipboard object() {
        return this;
    }

    public String getText() {
        WebDriver webDriver = this.driver.getWebDriver();
        if (AppiumDriverUnwrapper.isMobile((SearchContext)webDriver)) {
            return ((HasClipboard)webDriver).getClipboardText();
        }
        return this.defaultClipboard.getText();
    }

    public void setText(String text) {
        WebDriver webDriver = this.driver.getWebDriver();
        if (AppiumDriverUnwrapper.isMobile((SearchContext)webDriver)) {
            ((HasClipboard)webDriver).setClipboardText(text);
        } else {
            this.defaultClipboard.setText(text);
        }
    }
}

