/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SearchContext;

public class AppiumDriverUnwrapper {
    public static boolean isMobile(Driver driver) {
        return AppiumDriverUnwrapper.isMobile((SearchContext)driver.getWebDriver());
    }

    public static boolean isMobile(SearchContext driver) {
        if (AppiumDriverUnwrapper.hasCapability(driver, "appium:automationName")) {
            return true;
        }
        if (AppiumDriverUnwrapper.isWeb(driver)) {
            return false;
        }
        return WebdriverUnwrapper.instanceOf((SearchContext)driver, AppiumDriver.class);
    }

    public static boolean isAndroid(SearchContext driver) {
        if (AppiumDriverUnwrapper.isPlatform(driver, Platform.ANDROID)) {
            return true;
        }
        if (AppiumDriverUnwrapper.isPlatform(driver, Platform.IOS)) {
            return false;
        }
        if (AppiumDriverUnwrapper.isWeb(driver)) {
            return false;
        }
        return WebdriverUnwrapper.instanceOf((SearchContext)driver, AndroidDriver.class);
    }

    public static boolean isAndroid(Driver driver) {
        return AppiumDriverUnwrapper.isAndroid((SearchContext)driver.getWebDriver());
    }

    public static boolean isIos(SearchContext driver) {
        if (AppiumDriverUnwrapper.isPlatform(driver, Platform.IOS)) {
            return true;
        }
        if (AppiumDriverUnwrapper.isPlatform(driver, Platform.ANDROID)) {
            return false;
        }
        if (AppiumDriverUnwrapper.isWeb(driver)) {
            return false;
        }
        return WebdriverUnwrapper.instanceOf((SearchContext)driver, IOSDriver.class);
    }

    public static boolean isIos(Driver driver) {
        return AppiumDriverUnwrapper.isIos((SearchContext)driver.getWebDriver());
    }

    private static boolean hasCapability(SearchContext driver, String capabilityName) {
        if (driver instanceof HasCapabilities) {
            HasCapabilities hasCapabilities = (HasCapabilities)driver;
            Capabilities caps = hasCapabilities.getCapabilities();
            Object value = caps.getCapability(capabilityName);
            return value != null;
        }
        return false;
    }

    private static boolean isWeb(SearchContext driver) {
        return AppiumDriverUnwrapper.hasCapability(driver, "browserName");
    }

    private static boolean isPlatform(SearchContext driver, Platform platform) {
        if (driver instanceof HasCapabilities) {
            HasCapabilities hasCapabilities = (HasCapabilities)driver;
            Capabilities caps = hasCapabilities.getCapabilities();
            Platform platformName = (Platform)caps.getCapability("platformName");
            return platform.equals((Object)platformName);
        }
        return false;
    }
}

