/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.logevents.SelenideLogger;
import io.appium.java_client.InteractsWithApps;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.android.appmanagement.AndroidTerminateApplicationOptions;
import io.appium.java_client.appmanagement.BaseTerminateApplicationOptions;
import java.time.Duration;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebDriver;

public class AppiumNavigator {
    public void launchApp(Supplier<Runnable> driverSupplier) {
        Configuration.browserSize = null;
        Configuration.pageLoadTimeout = -1L;
        SelenideLogger.run((String)"launch app", (String)"", (Runnable)driverSupplier.get());
    }

    public void activateApp(WebDriver driver, String appId) {
        SelenideLogger.run((String)"activate app", (String)appId, () -> ((InteractsWithApps)driver).activateApp(appId));
    }

    public void terminateApp(WebDriver driver, String appId, @Nullable Duration timeout) {
        SelenideLogger.run((String)"terminate app", (String)appId, () -> {
            InteractsWithApps mobileDriver = (InteractsWithApps)driver;
            if (mobileDriver instanceof AndroidDriver) {
                AndroidDriver androidDriver = (AndroidDriver)mobileDriver;
                if (timeout != null) {
                    androidDriver.terminateApp(appId, (BaseTerminateApplicationOptions)this.options(timeout));
                    return;
                }
            }
            mobileDriver.terminateApp(appId);
        });
    }

    private AndroidTerminateApplicationOptions options(Duration timeout) {
        return new AndroidTerminateApplicationOptions().withTimeout(timeout);
    }
}

