/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.appium.SelenideAppium;
import com.codeborne.selenide.appium.SelenideAppiumElement;
import com.codeborne.selenide.logevents.SelenideLogger;
import io.appium.java_client.AppiumBy;
import java.time.Duration;
import java.util.Map;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class DeepLinkLauncher {
    public static Duration SAFARI_ELEMENTS_TIMEOUT = Duration.ofSeconds(1L);
    private static final String SAFARI_BUNDLE_ID = "com.apple.mobilesafari";

    public void openDeepLinkOnIos(WebDriver driver, String deepLinkUrl) {
        SelenideLogger.run((String)"open ios deeplink", (String)deepLinkUrl, () -> {
            SelenideAppiumElement openButton;
            this.openSafari(driver);
            driver.navigate().to(deepLinkUrl);
            if (!this.canAutoAcceptAlerts(driver) && (openButton = SelenideAppium.$(AppiumBy.iOSNsPredicateString((String)"type == 'XCUIElementTypeButton' && (name CONTAINS 'Open' OR name CONTAINS '\u041e\u0442\u043a\u0440\u044b\u0442\u044c')"))).is(Condition.enabled, SAFARI_ELEMENTS_TIMEOUT)) {
                openButton.click();
            }
        });
    }

    public void openDeepLinkOnAndroid(WebDriver driver, String deepLinkUrl, String appPackage) {
        SelenideLogger.run((String)"open android deeplink", (String)deepLinkUrl, () -> {
            Map<String, String> params = Map.of("url", deepLinkUrl, "package", appPackage);
            ((JavascriptExecutor)driver).executeScript("mobile: deepLink", new Object[]{params});
        });
    }

    private void openSafari(WebDriver driver) {
        ((JavascriptExecutor)driver).executeScript("mobile:launchApp", new Object[]{Map.of("bundleId", SAFARI_BUNDLE_ID)});
    }

    private boolean canAutoAcceptAlerts(WebDriver driver) {
        return ((HasCapabilities)driver).getCapabilities().is("autoAcceptAlerts");
    }
}

