/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.BaseElementsCollection;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.appium.SelenideAppiumCollection;
import com.codeborne.selenide.appium.SelenideAppiumElement;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.NoOpsList;
import com.codeborne.selenide.impl.SelenidePageFactory;
import com.codeborne.selenide.impl.WebElementSource;
import io.appium.java_client.HasBrowserCheck;
import io.appium.java_client.pagefactory.AndroidFindAll;
import io.appium.java_client.pagefactory.AndroidFindBy;
import io.appium.java_client.pagefactory.AndroidFindByAllSet;
import io.appium.java_client.pagefactory.AndroidFindByChainSet;
import io.appium.java_client.pagefactory.AndroidFindBySet;
import io.appium.java_client.pagefactory.AndroidFindBys;
import io.appium.java_client.pagefactory.AppiumFieldDecorator;
import io.appium.java_client.pagefactory.DefaultElementByBuilder;
import io.appium.java_client.pagefactory.iOSXCUITFindAll;
import io.appium.java_client.pagefactory.iOSXCUITFindBy;
import io.appium.java_client.pagefactory.iOSXCUITFindByAllSet;
import io.appium.java_client.pagefactory.iOSXCUITFindByChainSet;
import io.appium.java_client.pagefactory.iOSXCUITFindBySet;
import io.appium.java_client.pagefactory.iOSXCUITFindBys;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelenideAppiumPageFactory
extends SelenidePageFactory {
    private static final Logger logger = LoggerFactory.getLogger(SelenideAppiumPageFactory.class);
    private final List<Class<? extends Annotation>> platformAnnotations = List.of(AndroidFindBy.class, AndroidFindBys.class, AndroidFindAll.class, AndroidFindByAllSet.class, AndroidFindByChainSet.class, AndroidFindBySet.class, iOSXCUITFindBy.class, iOSXCUITFindBys.class, iOSXCUITFindAll.class, iOSXCUITFindByAllSet.class, iOSXCUITFindByChainSet.class, iOSXCUITFindBySet.class);

    protected By findSelector(Driver driver, Field field) {
        DefaultElementByBuilder builder = this.byBuilder(driver, field);
        builder.setAnnotated((AnnotatedElement)field);
        By selector = builder.buildBy();
        return selector != null ? selector : super.findSelector(driver, field);
    }

    private DefaultElementByBuilder byBuilder(Driver driver, Field field) {
        HasBrowserCheck hasBrowserCheck;
        if (!this.isPlatformAnnotationAdded(field)) {
            return new DefaultElementByBuilder(null, null);
        }
        if (!driver.hasWebDriverStarted()) {
            throw new WebDriverException("The SelenideAppiumPageFactory requires a webdriver instance to be created before page initialization; No webdriver is bound to current thread. You need to call open() first");
        }
        WebDriver webDriver = driver.getWebDriver();
        if (webDriver instanceof HasBrowserCheck && (hasBrowserCheck = (HasBrowserCheck)webDriver).isBrowser()) {
            return new DefaultElementByBuilder(null, null);
        }
        if (webDriver instanceof HasCapabilities) {
            HasCapabilities hasCapabilities = (HasCapabilities)webDriver;
            Capabilities d = hasCapabilities.getCapabilities();
            String platform = String.valueOf(d.getPlatformName());
            String automationName = String.valueOf(d.getCapability("automationName"));
            return new DefaultElementByBuilder(platform, automationName);
        }
        return new DefaultElementByBuilder(null, null);
    }

    protected FieldDecorator defaultFieldDecorator(Driver driver, @Nullable WebElementSource searchContext) {
        SearchContext context = this.getSearchContext(driver, searchContext);
        return new AppiumFieldDecorator(context);
    }

    public @Nullable Object decorate(ClassLoader loader, Driver driver, @Nullable WebElementSource searchContext, Field field, By selector, Type[] genericTypes) {
        if (selector instanceof ByIdOrName) {
            return this.decorateWithAppium(loader, searchContext, field);
        }
        return super.decorate(loader, driver, searchContext, field, selector, genericTypes);
    }

    private @Nullable Object decorateWithAppium(ClassLoader loader, @Nullable WebElementSource searchContext, Field field) {
        if (searchContext == null) {
            logger.warn("Cannot initialize field {}", (Object)field);
            return null;
        }
        AppiumFieldDecorator defaultAppiumFieldDecorator = new AppiumFieldDecorator((SearchContext)searchContext.getWebElement(), Duration.ZERO);
        Object appiumElement = defaultAppiumFieldDecorator.decorate(loader, field);
        if (appiumElement instanceof WebElement) {
            return Selenide.$((WebElement)((WebElement)appiumElement));
        }
        return appiumElement;
    }

    protected BaseElementsCollection<? extends SelenideElement, ? extends BaseElementsCollection<?, ?>> createCollection(CollectionSource collection, Class<?> klass) {
        return klass.isAssignableFrom(SelenideAppiumList.class) ? new SelenideAppiumList(collection) : super.createCollection(collection, klass);
    }

    private boolean isPlatformAnnotationAdded(Field field) {
        return this.platformAnnotations.stream().anyMatch(field::isAnnotationPresent);
    }

    protected Class<?> elementsBaseType() {
        return SelenideAppiumElement.class;
    }

    private static class SelenideAppiumList
    extends SelenideAppiumCollection
    implements NoOpsList<SelenideAppiumElement> {
        SelenideAppiumList(CollectionSource collection) {
            super(collection);
        }
    }
}

