/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.DragAndDropOptions;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import com.codeborne.selenide.commands.DragAndDrop;
import com.codeborne.selenide.impl.WebElementSource;
import java.time.Duration;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Pause;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppiumDragAndDrop
extends DragAndDrop {
    private static final Logger log = LoggerFactory.getLogger(AppiumDragAndDrop.class);

    protected void execute(WebElementSource locator, Object @Nullable [] args) {
        if (!AppiumDriverUnwrapper.isMobile(locator.driver())) {
            super.execute(locator, args);
            return;
        }
        DragAndDropOptions options = this.dragAndDropOptions(args, DragAndDropOptions.DragAndDropMethod.ACTIONS);
        if (options.getMethod() == DragAndDropOptions.DragAndDropMethod.JS) {
            log.debug("Drag'n'Drop with JavaScript is not supported in mobile apps");
        }
        SelenideElement target = options.getTarget(locator.driver());
        target.shouldBe(new WebElementCondition[]{Condition.visible});
        Sequence sequence = this.getSequenceToPerformDragAndDrop(this.getCenter(locator.getWebElement()), this.getCenter((WebElement)target));
        ((Interactive)locator.driver().getWebDriver()).perform(Collections.singletonList(sequence));
    }

    private Sequence getSequenceToPerformDragAndDrop(Point source, Point target) {
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
        return new Sequence((InputSource)finger, 1).addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), source.x, source.y)).addAction(finger.createPointerDown(PointerInput.MouseButton.MIDDLE.asArg())).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(600L))).addAction(finger.createPointerMove(Duration.ofMillis(600L), PointerInput.Origin.viewport(), target.x, target.y)).addAction(finger.createPointerUp(PointerInput.MouseButton.MIDDLE.asArg()));
    }

    private Point getCenter(WebElement element) {
        int x = element.getLocation().getX() + element.getSize().getWidth() / 2;
        int y = element.getLocation().getY() + element.getSize().getHeight() / 2;
        return new Point(x, y);
    }
}

