/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.FluentCommand;
import com.codeborne.selenide.ScrollOptions;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import com.codeborne.selenide.appium.AppiumScrollCoordinates;
import com.codeborne.selenide.appium.AppiumScrollOptions;
import com.codeborne.selenide.appium.ScrollDirection;
import com.codeborne.selenide.commands.ScrollTo;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.Arguments;
import com.codeborne.selenide.impl.WebElementSource;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;

public class AppiumScrollTo
extends FluentCommand {
    private static final AppiumScrollOptions DEFAULT_OPTIONS = AppiumScrollOptions.with(ScrollDirection.DOWN, 30);
    private final ScrollTo webImplementation = new ScrollTo();

    protected void execute(WebElementSource locator, Object @Nullable [] args) {
        if (AppiumDriverUnwrapper.isMobile(locator.driver())) {
            this.scrollInMobile(locator.driver().getWebDriver(), locator, args);
        } else {
            this.scrollInWebBrowser(locator, args);
        }
    }

    private AppiumScrollOptions extractOptions(Object @Nullable [] args) {
        if (args == null || args.length == 0) {
            return DEFAULT_OPTIONS;
        }
        if (args.length == 1) {
            return (AppiumScrollOptions)Util.firstOf((Object[])args);
        }
        throw new IllegalArgumentException("Unsupported scroll arguments: " + Arrays.toString(args));
    }

    private void scrollInWebBrowser(WebElementSource locator, Object @Nullable [] args) {
        if (new Arguments(args).ofType(AppiumScrollOptions.class).isPresent()) {
            throw new IllegalArgumentException("Scrolling with options is only supported for mobile drivers");
        }
        this.webImplementation.execute(locator, args);
    }

    private void scrollInMobile(WebDriver appiumDriver, WebElementSource locator, Object @Nullable [] args) {
        if (new Arguments(args).ofType(ScrollOptions.class).isPresent()) {
            throw new IllegalArgumentException("Use scroll(AppiumScrollOptions) instead of scroll(ScrollOptions)");
        }
        AppiumScrollOptions scrollOptions = this.extractOptions(args);
        int currentSwipeCount = 0;
        while (this.isElementNotDisplayed(locator) && this.isLessThanMaxSwipeCount(currentSwipeCount, scrollOptions.getMaxSwipeCount())) {
            this.performScroll(appiumDriver, scrollOptions.getScrollDirection(), scrollOptions.getTopPointHeightPercent(), scrollOptions.getBottomPointHeightPercent());
            ++currentSwipeCount;
        }
    }

    private boolean isLessThanMaxSwipeCount(int currentSwipeCount, int maxSwipeCounts) {
        return currentSwipeCount < maxSwipeCounts;
    }

    private boolean isElementNotDisplayed(WebElementSource locator) {
        try {
            return !locator.getWebElement().isDisplayed();
        }
        catch (NoSuchElementException noSuchElementException) {
            return true;
        }
    }

    private Dimension getMobileDeviceSize(WebDriver appiumDriver) {
        return appiumDriver.manage().window().getSize();
    }

    private void performScroll(WebDriver appiumDriver, ScrollDirection scrollDirection, float top, float bottom) {
        Dimension size = this.getMobileDeviceSize(appiumDriver);
        AppiumScrollCoordinates scrollCoordinates = this.getScrollCoordinates(scrollDirection, size, top, bottom);
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
        Sequence sequenceToPerformScroll = this.getSequenceToPerformScroll(finger, scrollCoordinates);
        ((Interactive)appiumDriver).perform(Collections.singletonList(sequenceToPerformScroll));
    }

    private AppiumScrollCoordinates getScrollCoordinates(ScrollDirection scrollDirection, Dimension size, float top, float bottom) {
        if (scrollDirection == ScrollDirection.UP) {
            return new AppiumScrollCoordinates(size.getWidth() / 2, (int)((float)size.getHeight() * top), size.getWidth() / 2, (int)((float)size.getHeight() * bottom));
        }
        return new AppiumScrollCoordinates(size.getWidth() / 2, (int)((float)size.getHeight() * bottom), size.getWidth() / 2, (int)((float)size.getHeight() * top));
    }

    private Sequence getSequenceToPerformScroll(PointerInput finger, AppiumScrollCoordinates scrollCoordinates) {
        return new Sequence((InputSource)finger, 1).addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), scrollCoordinates.getStartX(), scrollCoordinates.getStartY())).addAction(finger.createPointerDown(PointerInput.MouseButton.MIDDLE.asArg())).addAction(finger.createPointerMove(Duration.ofMillis(200L), PointerInput.Origin.viewport(), scrollCoordinates.getEndX(), scrollCoordinates.getEndY())).addAction(finger.createPointerUp(PointerInput.MouseButton.MIDDLE.asArg()));
    }
}

