/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.FluentCommand;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import com.codeborne.selenide.appium.AppiumScrollCoordinates;
import com.codeborne.selenide.appium.AppiumSwipeDirection;
import com.codeborne.selenide.appium.AppiumSwipeOptions;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.WebElementSource;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;

public class AppiumSwipeTo
extends FluentCommand {
    private static final AppiumSwipeOptions DEFAULT_OPTIONS = AppiumSwipeOptions.right();

    protected void execute(WebElementSource locator, Object @Nullable [] args) {
        AppiumSwipeOptions appiumSwipeOptions = this.extractOptions(args);
        if (!AppiumDriverUnwrapper.isMobile(locator.driver())) {
            throw new IllegalArgumentException("Swipe is supported only in Appium");
        }
        this.swipeInMobile(locator, appiumSwipeOptions);
    }

    private void swipeInMobile(WebElementSource locator, AppiumSwipeOptions appiumSwipeOptions) {
        WebDriver appiumDriver = locator.driver().getWebDriver();
        int currentSwipeCount = 0;
        while (this.isElementNotDisplayed(locator) && this.isLessThanMaxSwipeCount(currentSwipeCount, appiumSwipeOptions.getMaxSwipeCounts())) {
            this.performSwipe(appiumDriver, appiumSwipeOptions.getAppiumSwipeDirection());
            ++currentSwipeCount;
        }
    }

    private boolean isLessThanMaxSwipeCount(int currentSwipeCount, int maxSwipeCounts) {
        return currentSwipeCount < maxSwipeCounts;
    }

    private boolean isElementNotDisplayed(WebElementSource locator) {
        try {
            return !locator.getWebElement().isDisplayed();
        }
        catch (NoSuchElementException noSuchElementException) {
            return true;
        }
    }

    private Dimension getMobileDeviceSize(WebDriver appiumDriver) {
        return appiumDriver.manage().window().getSize();
    }

    private void performSwipe(WebDriver appiumDriver, AppiumSwipeDirection swipeDirection) {
        Dimension size = this.getMobileDeviceSize(appiumDriver);
        AppiumScrollCoordinates scrollCoordinates = this.getScrollCoordinates(swipeDirection, size);
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
        Sequence sequenceToPerformScroll = this.getSequenceToPerformSwipe(finger, scrollCoordinates);
        ((Interactive)appiumDriver).perform(Collections.singletonList(sequenceToPerformScroll));
    }

    private AppiumScrollCoordinates getScrollCoordinates(AppiumSwipeDirection swipeDirection, Dimension size) {
        if (swipeDirection == AppiumSwipeDirection.RIGHT) {
            return new AppiumScrollCoordinates((int)((double)size.getWidth() * 0.75), size.getHeight() / 2, (int)((double)size.getWidth() * 0.25), size.getHeight() / 2);
        }
        return new AppiumScrollCoordinates((int)((double)size.getWidth() * 0.25), size.getHeight() / 2, (int)((double)size.getWidth() * 0.75), size.getHeight() / 2);
    }

    private Sequence getSequenceToPerformSwipe(PointerInput finger, AppiumScrollCoordinates scrollCoordinates) {
        return new Sequence((InputSource)finger, 1).addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), scrollCoordinates.getStartX(), scrollCoordinates.getStartY())).addAction(finger.createPointerDown(PointerInput.MouseButton.MIDDLE.asArg())).addAction(finger.createPointerMove(Duration.ofMillis(200L), PointerInput.Origin.viewport(), scrollCoordinates.getEndX(), scrollCoordinates.getEndY())).addAction(finger.createPointerUp(PointerInput.MouseButton.MIDDLE.asArg()));
    }

    private AppiumSwipeOptions extractOptions(Object @Nullable [] args) {
        if (args == null || args.length == 0) {
            return DEFAULT_OPTIONS;
        }
        if (args.length == 1) {
            return (AppiumSwipeOptions)Util.firstOf((Object[])args);
        }
        throw new IllegalArgumentException("Unsupported swipe arguments: " + Arrays.toString(args));
    }
}

