/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.FluentCommand;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import com.codeborne.selenide.impl.WebElementSource;
import io.appium.java_client.HasOnScreenKeyboard;
import io.appium.java_client.HidesKeyboard;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class HideKeyboard
extends FluentCommand {
    protected void execute(WebElementSource locator, Object @Nullable [] args) {
        WebDriver webDriver = locator.driver().getWebDriver();
        if (AppiumDriverUnwrapper.isAndroid((SearchContext)webDriver)) {
            this.hideKeyBoardForAndroid((HasOnScreenKeyboard)((HidesKeyboard)webDriver));
        } else if (AppiumDriverUnwrapper.isIos((SearchContext)webDriver)) {
            this.hideKeyBoardForIos((HasOnScreenKeyboard)webDriver, locator.getWebElement());
        } else {
            throw new UnsupportedOperationException("Cannot hide keyboard for webdriver " + String.valueOf(webDriver));
        }
    }

    private <T extends HasOnScreenKeyboard & HidesKeyboard> void hideKeyBoardForAndroid(T driver) {
        if (driver.isKeyboardShown()) {
            ((HidesKeyboard)driver).hideKeyboard();
        }
    }

    private void hideKeyBoardForIos(HasOnScreenKeyboard driver, WebElement element) {
        if (driver.isKeyboardShown()) {
            element.sendKeys(new CharSequence[]{"\n"});
        }
    }
}

