/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.DefaultClipboard;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import io.appium.java_client.clipboard.HasClipboard;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AppiumClipboard
implements Clipboard {
    private final Driver driver;
    private final Clipboard defaultClipboard;

    public AppiumClipboard(Driver driver) {
        this.driver = driver;
        this.defaultClipboard = new DefaultClipboard(driver);
    }

    @Nonnull
    @CheckReturnValue
    public Driver driver() {
        return this.driver;
    }

    @Nonnull
    @CheckReturnValue
    public Clipboard object() {
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public String getText() {
        return this.getWebDriver().map(HasClipboard::getClipboardText).orElseGet(() -> ((Clipboard)this.defaultClipboard).getText());
    }

    public void setText(String text) {
        Optional<HasClipboard> mobileDriver = this.getWebDriver();
        if (mobileDriver.isPresent()) {
            mobileDriver.get().setClipboardText(text);
        } else {
            this.defaultClipboard.setText(text);
        }
    }

    private Optional<HasClipboard> getWebDriver() {
        return WebdriverUnwrapper.cast((Driver)this.driver, HasClipboard.class);
    }
}

