/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.appium.ScrollDirection;

public class AppiumScrollOptions {
    private final ScrollDirection scrollDirection;
    private final int maxSwipeCounts;
    private final float topPointHeightPercent;
    private final float bottomPointHeightPercent;
    private static final int DEFAULT_MAX_SWIPE_COUNTS = 30;
    private static final float DEFAULT_TOP_POINT_HEIGHT_PERCENT = 0.25f;
    private static final float DEFAULT_BOTTOM_POINT_HEIGHT_PERCENT = 0.5f;

    private AppiumScrollOptions(ScrollDirection scrollDirection, int maxSwipeCounts) {
        this(scrollDirection, maxSwipeCounts, 0.25f, 0.5f);
    }

    private AppiumScrollOptions(ScrollDirection scrollDirection, int maxSwipeCounts, float topPointHeightPercent, float bottomPointHeightPercent) {
        this.checkCoordinateValues(topPointHeightPercent, bottomPointHeightPercent);
        this.scrollDirection = scrollDirection;
        this.maxSwipeCounts = maxSwipeCounts;
        this.topPointHeightPercent = topPointHeightPercent;
        this.bottomPointHeightPercent = bottomPointHeightPercent;
    }

    private void checkCoordinateValues(float topPointHeightPercent, float bottomPointHeightPercent) {
        if (topPointHeightPercent <= 0.0f || topPointHeightPercent >= 1.0f || bottomPointHeightPercent <= 0.0f || bottomPointHeightPercent >= 1.0f) {
            throw new IllegalArgumentException("Percentage height should be greater than 0 and less than 1. Example: (0.2, 0.5)");
        }
        if (topPointHeightPercent > bottomPointHeightPercent) {
            throw new IllegalArgumentException("Top point percentage should be less than bottom point percentage. Example: (0.1, 0.5)");
        }
    }

    public static AppiumScrollOptions with(ScrollDirection scrollDirection, int maxSwipeCounts) {
        return new AppiumScrollOptions(scrollDirection, maxSwipeCounts);
    }

    public static AppiumScrollOptions with(ScrollDirection scrollDirection, float topPointHeightPercent, float bottomPointHeightPercent) {
        return new AppiumScrollOptions(scrollDirection, 30, topPointHeightPercent, bottomPointHeightPercent);
    }

    public static AppiumScrollOptions down() {
        return new AppiumScrollOptions(ScrollDirection.DOWN, 30);
    }

    public static AppiumScrollOptions down(int maxSwipeCounts) {
        return new AppiumScrollOptions(ScrollDirection.DOWN, maxSwipeCounts);
    }

    public static AppiumScrollOptions up() {
        return new AppiumScrollOptions(ScrollDirection.UP, 30);
    }

    public static AppiumScrollOptions up(int maxSwipeCounts) {
        return new AppiumScrollOptions(ScrollDirection.UP, maxSwipeCounts);
    }

    public static AppiumScrollOptions up(float topPointHeightPercent, float bottomPointHeightPercent) {
        return new AppiumScrollOptions(ScrollDirection.UP, 30, topPointHeightPercent, bottomPointHeightPercent);
    }

    public static AppiumScrollOptions down(float topPointHeightPercent, float bottomPointHeightPercent) {
        return new AppiumScrollOptions(ScrollDirection.DOWN, 30, topPointHeightPercent, bottomPointHeightPercent);
    }

    public int getMaxSwipeCounts() {
        return this.maxSwipeCounts;
    }

    public ScrollDirection getScrollDirection() {
        return this.scrollDirection;
    }

    public float getTopPointHeightPercent() {
        return this.topPointHeightPercent;
    }

    public float getBottomPointHeightPercent() {
        return this.bottomPointHeightPercent;
    }
}

