/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.SearchContext;

@ParametersAreNonnullByDefault
public class HideKeyboard
implements Command<Object> {
    @Nullable
    public Object execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        Optional androidDriver = WebdriverUnwrapper.cast((SearchContext)locator.driver().getWebDriver(), AndroidDriver.class);
        Optional iosDriver = WebdriverUnwrapper.cast((SearchContext)locator.driver().getWebDriver(), IOSDriver.class);
        if (androidDriver.isPresent()) {
            this.hideKeyBoardForAndroid((AndroidDriver)androidDriver.get());
        } else if (iosDriver.isPresent()) {
            this.hideKeyBoardForIos((IOSDriver)iosDriver.get(), proxy);
        } else {
            throw new UnsupportedOperationException("Cannot hide keyboard for webdriver " + locator.driver().getWebDriver());
        }
        return proxy;
    }

    private void hideKeyBoardForAndroid(AndroidDriver driver) {
        if (driver.isKeyboardShown()) {
            driver.hideKeyboard();
        }
    }

    private void hideKeyBoardForIos(IOSDriver driver, SelenideElement element) {
        if (driver.isKeyboardShown()) {
            element.sendKeys(new CharSequence[]{"\n"});
        }
    }
}

