/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.appium.SelenideAppium;
import com.codeborne.selenide.appium.SelenideAppiumElement;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.ios.IOSDriver;
import java.time.Duration;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.SearchContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.CheckReturnValue;

@ParametersAreNonnullByDefault
public class DeepLinkLauncher {
    public static Duration SAFARI_ELEMENTS_TIMEOUT = Duration.ofSeconds(1L);
    private static final String SAFARI_BUNDLE_ID = "com.apple.mobilesafari";
    private static final Logger log = LoggerFactory.getLogger(DeepLinkLauncher.class);

    public void openDeepLinkOnIos(IOSDriver driver, String deepLinkUrl) {
        SelenideLogger.run((String)"open ios deeplink", (String)deepLinkUrl, () -> {
            SelenideAppiumElement openButton;
            this.openSafari((AppiumDriver)driver);
            driver.navigate().to(deepLinkUrl);
            if (!this.canAutoAcceptAlerts((AppiumDriver)driver) && (openButton = SelenideAppium.$(AppiumBy.iOSNsPredicateString((String)"type == 'XCUIElementTypeButton' && (name CONTAINS 'Open' OR name CONTAINS '\u041e\u0442\u043a\u0440\u044b\u0442\u044c')"))).is(Condition.enabled, SAFARI_ELEMENTS_TIMEOUT)) {
                openButton.click();
            }
        });
    }

    public void openDeepLinkOnAndroid(AppiumDriver driver, String deepLinkUrl, String appPackage) {
        SelenideLogger.run((String)"open android deeplink", (String)deepLinkUrl, () -> {
            ImmutableMap params = ImmutableMap.of((Object)"url", (Object)deepLinkUrl, (Object)"package", (Object)appPackage);
            driver.executeScript("mobile: deepLink", new Object[]{params});
        });
    }

    private void openSafari(AppiumDriver driver) {
        driver.executeScript("mobile:launchApp", new Object[]{ImmutableMap.of((Object)"bundleId", (Object)SAFARI_BUNDLE_ID)});
    }

    @CheckReturnValue
    private boolean canAutoAcceptAlerts(AppiumDriver driver) {
        HasCapabilities hasCapabilities = (HasCapabilities)WebdriverUnwrapper.cast((SearchContext)driver, HasCapabilities.class).orElseThrow(() -> new IllegalArgumentException("Driver doesn't support HasCapabilities"));
        Capabilities capabilities = hasCapabilities.getCapabilities();
        return capabilities.is("autoAcceptAlerts");
    }
}

