/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.ClickMethod;
import com.codeborne.selenide.ClickOptions;
import com.codeborne.selenide.appium.commands.AppiumClickMethod;
import java.time.Duration;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AppiumClickOptions
extends ClickOptions {
    private final AppiumClickMethod appiumClickMethod;
    private final Duration longPressHoldDuration;
    private static final Duration DEFAULT_LONG_PRESS_DURATION = Duration.ofSeconds(3L);

    private AppiumClickOptions(AppiumClickMethod appiumClickMethod, int offsetX, int offsetY, Duration longPressHoldDuration) {
        super(ClickMethod.DEFAULT, offsetX, offsetY, null, true);
        this.appiumClickMethod = appiumClickMethod;
        this.longPressHoldDuration = longPressHoldDuration;
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumClickOptions tap() {
        return new AppiumClickOptions(AppiumClickMethod.TAP, 0, 0, Duration.ZERO);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumClickOptions tapWithOffset(int xOffset, int yOffset) {
        return new AppiumClickOptions(AppiumClickMethod.TAP_WITH_OFFSET, xOffset, yOffset, Duration.ZERO);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumClickOptions doubleTap() {
        return new AppiumClickOptions(AppiumClickMethod.DOUBLE_TAP, 0, 0, Duration.ZERO);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumClickOptions longPress() {
        return new AppiumClickOptions(AppiumClickMethod.LONG_PRESS, 0, 0, DEFAULT_LONG_PRESS_DURATION);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumClickOptions longPressFor(Duration longPressHoldDuration) {
        return new AppiumClickOptions(AppiumClickMethod.LONG_PRESS, 0, 0, longPressHoldDuration);
    }

    @Nonnull
    @CheckReturnValue
    public AppiumClickMethod appiumClickMethod() {
        return this.appiumClickMethod;
    }

    @Nonnull
    @CheckReturnValue
    public Duration longPressHoldDuration() {
        return this.longPressHoldDuration;
    }
}

