/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.appium.ScrollDirection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AppiumScrollOptions {
    private final ScrollDirection scrollDirection;
    private final int maxSwipeCount;
    private final float topPointHeightPercent;
    private final float bottomPointHeightPercent;
    private static final int DEFAULT_MAX_SWIPE_COUNTS = 30;
    private static final float DEFAULT_TOP_POINT_HEIGHT_PERCENT = 0.25f;
    private static final float DEFAULT_BOTTOM_POINT_HEIGHT_PERCENT = 0.5f;

    private AppiumScrollOptions(ScrollDirection scrollDirection, int maxSwipeCount) {
        this(scrollDirection, maxSwipeCount, 0.25f, 0.5f);
    }

    private AppiumScrollOptions(ScrollDirection scrollDirection, int maxSwipeCount, float topPointHeightPercent, float bottomPointHeightPercent) {
        this.checkCoordinateValues(topPointHeightPercent, bottomPointHeightPercent);
        this.scrollDirection = scrollDirection;
        this.maxSwipeCount = maxSwipeCount;
        this.topPointHeightPercent = AppiumScrollOptions.validatePercentage("Top point height percentage", topPointHeightPercent);
        this.bottomPointHeightPercent = AppiumScrollOptions.validatePercentage("Bottom point height percentage", bottomPointHeightPercent);
    }

    private static float validatePercentage(String name, float value) {
        if (value <= 0.0f || value >= 1.0f) {
            throw new IllegalArgumentException(name + " should be greater than 0 and less than 1. Example: (0.2, 0.5)");
        }
        return value;
    }

    private void checkCoordinateValues(float topPointHeightPercent, float bottomPointHeightPercent) {
        if (topPointHeightPercent > bottomPointHeightPercent) {
            throw new IllegalArgumentException("Top point percentage should be less than bottom point percentage. Example: (0.1, 0.5)");
        }
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumScrollOptions with(ScrollDirection scrollDirection, int maxSwipeCount) {
        return new AppiumScrollOptions(scrollDirection, maxSwipeCount);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumScrollOptions with(ScrollDirection scrollDirection, float topPointHeightPercent, float bottomPointHeightPercent) {
        return new AppiumScrollOptions(scrollDirection, 30, topPointHeightPercent, bottomPointHeightPercent);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumScrollOptions down() {
        return new AppiumScrollOptions(ScrollDirection.DOWN, 30);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumScrollOptions down(int maxSwipeCount) {
        return new AppiumScrollOptions(ScrollDirection.DOWN, maxSwipeCount);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumScrollOptions up() {
        return new AppiumScrollOptions(ScrollDirection.UP, 30);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumScrollOptions up(int maxSwipeCount) {
        return new AppiumScrollOptions(ScrollDirection.UP, maxSwipeCount);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumScrollOptions up(float topPointHeightPercent, float bottomPointHeightPercent) {
        return new AppiumScrollOptions(ScrollDirection.UP, 30, topPointHeightPercent, bottomPointHeightPercent);
    }

    @Nonnull
    @CheckReturnValue
    public static AppiumScrollOptions down(float topPointHeightPercent, float bottomPointHeightPercent) {
        return new AppiumScrollOptions(ScrollDirection.DOWN, 30, topPointHeightPercent, bottomPointHeightPercent);
    }

    @CheckReturnValue
    @Deprecated
    public int getMaxSwipeCounts() {
        return this.maxSwipeCount;
    }

    @CheckReturnValue
    public int getMaxSwipeCount() {
        return this.maxSwipeCount;
    }

    @Nonnull
    @CheckReturnValue
    public ScrollDirection getScrollDirection() {
        return this.scrollDirection;
    }

    @CheckReturnValue
    public float getTopPointHeightPercent() {
        return this.topPointHeightPercent;
    }

    @CheckReturnValue
    public float getBottomPointHeightPercent() {
        return this.bottomPointHeightPercent;
    }

    public String toString() {
        return String.format("%s, max swipes: %s, top height: %s, bottom height: %s", new Object[]{this.scrollDirection, this.maxSwipeCount, Float.valueOf(this.topPointHeightPercent), Float.valueOf(this.bottomPointHeightPercent)});
    }
}

