/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.appium.AppiumDriverRunner;
import com.codeborne.selenide.appium.AppiumNavigator;
import com.codeborne.selenide.appium.DeepLinkLauncher;
import com.codeborne.selenide.appium.SelenideAppiumCollection;
import com.codeborne.selenide.appium.SelenideAppiumElement;
import com.codeborne.selenide.appium.SelenideAppiumTargetLocator;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.WebElementWrapper;
import io.appium.java_client.AppiumDriver;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class SelenideAppium {
    private static final AppiumNavigator appiumNavigator = new AppiumNavigator();
    private static final DeepLinkLauncher deepLinkLauncher = new DeepLinkLauncher();

    private SelenideAppium() {
    }

    public static void launchApp() {
        appiumNavigator.launchApp(() -> WebDriverRunner::getAndCheckWebDriver);
    }

    public static void openIOSDeepLink(@Nonnull String deepLinkUrl) {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            SelenideAppium.launchApp();
        }
        deepLinkLauncher.openDeepLinkOnIos(AppiumDriverRunner.getIosDriver(), deepLinkUrl);
    }

    public static void openAndroidDeepLink(@Nonnull String deepLinkUrl, @Nonnull String appPackage) {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            SelenideAppium.launchApp();
        }
        deepLinkLauncher.openDeepLinkOnAndroid((AppiumDriver)AppiumDriverRunner.getMobileDriver(), deepLinkUrl, appPackage);
    }

    public static void terminateApp(String appId) {
        appiumNavigator.terminateApp((AppiumDriver)AppiumDriverRunner.getMobileDriver(), appId);
    }

    public static void back() {
        Selenide.back();
    }

    @Nonnull
    @CheckReturnValue
    public static SelenideAppiumTargetLocator switchTo() {
        return new SelenideAppiumTargetLocator(WebDriverRunner.driver());
    }

    @Nonnull
    @CheckReturnValue
    public static Set<String> getContextHandles() {
        return SelenideAppium.switchTo().getContextHandles();
    }

    @Nonnull
    @CheckReturnValue
    public static String getCurrentContext() {
        return SelenideAppium.switchTo().getCurrentContext();
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideAppiumElement $x(String xpathExpression) {
        return SelenideAppium.$(By.xpath((String)xpathExpression), 0);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideAppiumElement $(By seleniumSelector) {
        return SelenideAppium.$(seleniumSelector, 0);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideAppiumElement $(By seleniumSelector, int index) {
        return (SelenideAppiumElement)ElementFinder.wrap((Driver)WebDriverRunner.driver(), SelenideAppiumElement.class, null, (By)seleniumSelector, (int)index);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideAppiumElement $(WebElement webElement) {
        return (SelenideAppiumElement)WebElementWrapper.wrap(SelenideAppiumElement.class, (Driver)WebDriverRunner.driver(), (WebElement)webElement);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideAppiumCollection $$(By selector) {
        return new SelenideAppiumCollection(WebDriverRunner.driver(), selector);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideAppiumCollection $$(Collection<? extends WebElement> elements) {
        return new SelenideAppiumCollection(WebDriverRunner.driver(), elements);
    }
}

