/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.DragAndDropOptions;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.commands.DragAndDrop;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import io.appium.java_client.AppiumDriver;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.Pause;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class AppiumDragAndDrop
extends DragAndDrop {
    private static final Logger log = LoggerFactory.getLogger(AppiumDragAndDrop.class);

    @Nonnull
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        Optional appiumDriverOptional = WebdriverUnwrapper.cast((Driver)locator.driver(), AppiumDriver.class);
        if (!appiumDriverOptional.isPresent()) {
            return super.execute(proxy, locator, args);
        }
        AppiumDriver appiumDriver = (AppiumDriver)appiumDriverOptional.get();
        DragAndDropOptions options = this.dragAndDropOptions(args, DragAndDropOptions.DragAndDropMethod.ACTIONS);
        if (options.getMethod() == DragAndDropOptions.DragAndDropMethod.JS) {
            log.debug("Drag'n'Drop with JavaScript is not supported in mobile apps");
        }
        SelenideElement target = options.getTarget(locator.driver());
        target.shouldBe(new WebElementCondition[]{Condition.visible});
        Sequence sequence = this.getSequenceToPerformDragAndDrop(this.getCenter(locator.getWebElement()), this.getCenter((WebElement)target));
        appiumDriver.perform(Collections.singletonList(sequence));
        return proxy;
    }

    @Nonnull
    @CheckReturnValue
    private Sequence getSequenceToPerformDragAndDrop(Point source, Point target) {
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
        return new Sequence((InputSource)finger, 1).addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), source.x, source.y)).addAction(finger.createPointerDown(PointerInput.MouseButton.MIDDLE.asArg())).addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(600L))).addAction(finger.createPointerMove(Duration.ofMillis(600L), PointerInput.Origin.viewport(), target.x, target.y)).addAction(finger.createPointerUp(PointerInput.MouseButton.MIDDLE.asArg()));
    }

    @Nonnull
    @CheckReturnValue
    private Point getCenter(WebElement element) {
        int x = element.getLocation().getX() + element.getSize().getWidth() / 2;
        int y = element.getLocation().getY() + element.getSize().getHeight() / 2;
        return new Point(x, y);
    }
}

