/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.conditions;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class CombinedAttribute {
    @Nullable
    private final String androidAttribute;
    @Nullable
    private final String iosAttribute;

    private CombinedAttribute(@Nullable String androidAttribute, @Nullable String iosAttribute) {
        this.androidAttribute = androidAttribute;
        this.iosAttribute = iosAttribute;
    }

    @Nonnull
    @CheckReturnValue
    public static CombinedAttribute android(String android) {
        return new CombinedAttribute(android, null);
    }

    @Nonnull
    @CheckReturnValue
    public CombinedAttribute ios(String ios) {
        return new CombinedAttribute(this.androidAttribute, ios);
    }

    @Nullable
    @CheckReturnValue
    public String getAttributeValue(Driver driver, WebElement element) {
        return element.getAttribute(this.getAttributeName(driver));
    }

    @Nonnull
    @CheckReturnValue
    private String getAttributeName(Driver driver) {
        if (AppiumDriverUnwrapper.isAndroid(driver)) {
            return Objects.requireNonNull(this.androidAttribute, "Android selector not given");
        }
        if (AppiumDriverUnwrapper.isIos(driver)) {
            return Objects.requireNonNull(this.iosAttribute, "iOS selector not given");
        }
        throw new UnsupportedOperationException("Unsupported webdriver: " + WebDriverRunner.getWebDriver());
    }
}

