/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import org.openqa.selenium.SearchContext;

public class AppiumDriverRunner {
    public static AndroidDriver getAndroidDriver() {
        return (AndroidDriver)WebdriverUnwrapper.cast((SearchContext)WebDriverRunner.getWebDriver(), AndroidDriver.class).orElseThrow(() -> new ClassCastException("WebDriver cannot be casted to AndroidDriver"));
    }

    public static IOSDriver getIosDriver() {
        return (IOSDriver)WebdriverUnwrapper.cast((SearchContext)WebDriverRunner.getWebDriver(), IOSDriver.class).orElseThrow(() -> new ClassCastException("WebDriver cannot be casted to IosDriver"));
    }

    public static <T extends AppiumDriver> T getMobileDriver() {
        if (AppiumDriverRunner.isAndroidDriver() || AppiumDriverRunner.isIosDriver()) {
            return (T)(AppiumDriverRunner.isAndroidDriver() ? AppiumDriverRunner.getAndroidDriver() : AppiumDriverRunner.getIosDriver());
        }
        throw new ClassCastException("WebDriver is not instance of AndroidDriver or IOSDriver: " + WebDriverRunner.getWebDriver());
    }

    public static boolean isAndroidDriver() {
        return AppiumDriverUnwrapper.isAndroid((SearchContext)WebDriverRunner.getWebDriver());
    }

    public static boolean isIosDriver() {
        return AppiumDriverUnwrapper.isIos((SearchContext)WebDriverRunner.getWebDriver());
    }
}

