/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.SelenideElementDescriber;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import io.appium.java_client.AppiumDriver;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppiumElementDescriber
implements ElementDescriber {
    private static final Logger logger = LoggerFactory.getLogger(AppiumElementDescriber.class);
    private static final Pattern RE_IOS_UNSUPPORTED_ATTRIBUTE = Pattern.compile(".*The attribute '\\w+' is unknown.*", 32);
    private static final SelenideElementDescriber webVersion = new SelenideElementDescriber();

    public String fully(Driver driver, @Nullable WebElement element) {
        if (element == null) {
            return "null";
        }
        return WebdriverUnwrapper.cast((Driver)driver, AppiumDriver.class).map(appiumDriver -> new Builder(element, (AppiumDriver)appiumDriver, this.supportedAttributes(driver)).appendTagName().appendAttributes().finish().build()).orElseGet(() -> webVersion.fully(driver, element));
    }

    protected List<String> supportedAttributes(Driver driver) {
        if (AppiumDriverUnwrapper.isAndroid(driver)) {
            return this.androidAttributes();
        }
        if (AppiumDriverUnwrapper.isIos(driver)) {
            return this.iosAttributes();
        }
        return this.genericAttributes();
    }

    protected List<String> androidAttributes() {
        return Arrays.asList("resource-id", "checked", "content-desc", "enabled", "focused", "package", "name", "className", "bounds", "displayed");
    }

    protected List<String> iosAttributes() {
        return Arrays.asList("enabled", "selected", "name", "value", "visible");
    }

    protected List<String> genericAttributes() {
        return Arrays.asList("checked", "content-desc", "enabled", "name", "displayed");
    }

    public String briefly(Driver driver, WebElement element) {
        return WebdriverUnwrapper.cast((Driver)driver, AppiumDriver.class).map(appiumDriver -> new Builder(element, (AppiumDriver)appiumDriver, this.supportedAttributes(driver)).appendTagName().finish().build()).orElseGet(() -> webVersion.fully(driver, element));
    }

    public String selector(By selector) {
        if (selector instanceof By.ByCssSelector) {
            return selector.toString().replace("By.selector: ", "").replace("By.cssSelector: ", "");
        }
        return selector.toString();
    }

    static String removePackage(String className) {
        int i = className.lastIndexOf(46);
        return i < 0 ? className : className.substring(i + 1);
    }

    static boolean isUnsupportedAttributeError(WebDriverException e) {
        return e instanceof UnsupportedCommandException || RE_IOS_UNSUPPORTED_ATTRIBUTE.matcher(e.getMessage()).matches();
    }

    private static class Builder {
        private final WebElement element;
        private final AppiumDriver webDriver;
        private final List<String> supportedAttributes;
        private String tagName = "?";
        private String text = "?";
        private final StringBuilder sb = new StringBuilder();
        private @Nullable WebDriverException unforgivableException;

        private Builder(WebElement element, AppiumDriver webDriver, List<String> supportedAttributes) {
            this.element = element;
            this.webDriver = webDriver;
            this.supportedAttributes = supportedAttributes;
        }

        private Builder appendTagName() {
            if (AppiumDriverUnwrapper.isAndroid((SearchContext)this.webDriver)) {
                this.getAttribute("class", className -> {
                    this.tagName = AppiumElementDescriber.removePackage(className);
                });
            }
            if ("?".equals(this.tagName)) {
                this.safeCall(() -> ((WebElement)this.element).getTagName(), () -> "Failed to get tag name", tag -> {
                    this.tagName = tag;
                });
            }
            this.sb.append("<").append(this.tagName);
            return this;
        }

        private Builder appendAttributes() {
            this.supportedAttributes.forEach(this::appendAttribute);
            return this;
        }

        private void appendAttribute(String name) {
            this.getAttribute(name, value -> this.sb.append(" ").append(name).append("=\"").append((String)value).append("\""));
        }

        private void getAttribute(String name, Consumer<String> attributeHandler) {
            this.safeCall(() -> this.element.getAttribute(name), () -> "Failed to get attribute " + name, attributeHandler);
        }

        private void safeCall(Supplier<@Nullable String> method, Supplier<String> errorMessage, Consumer<String> resultHandler) {
            if (this.unforgivableException != null) {
                return;
            }
            try {
                String value = method.get();
                if (value != null) {
                    resultHandler.accept(value);
                }
            }
            catch (NoSuchElementException | StaleElementReferenceException e) {
                this.unforgivableException = e;
                logger.debug("{}: {}", (Object)errorMessage.get(), (Object)e.toString());
            }
            catch (WebDriverException e) {
                if (AppiumElementDescriber.isUnsupportedAttributeError(e)) {
                    logger.debug("{}: {}", (Object)errorMessage.get(), (Object)e.toString());
                } else {
                    logger.info("{}: {}", (Object)errorMessage.get(), (Object)e.toString());
                }
            }
            catch (RuntimeException e) {
                logger.warn("{}", (Object)errorMessage.get(), (Object)e);
            }
        }

        public Builder finish() {
            this.sb.append(">");
            if (this.unforgivableException != null) {
                this.sb.append((Object)this.unforgivableException);
            } else {
                this.appendText();
            }
            this.sb.append("</").append(this.tagName).append(">");
            return this;
        }

        private void appendText() {
            this.safeCall(() -> ((WebElement)this.element).getText(), () -> "Failed to get text", value -> {
                this.text = value;
            });
            if ("?".equals(this.text) || this.text.isEmpty()) {
                this.getAttribute("text", value -> {
                    this.text = value;
                });
            }
            if ("?".equals(this.text)) {
                this.getAttribute("label", value -> {
                    this.text = value;
                });
            }
            if ("?".equals(this.text)) {
                this.getAttribute("value", value -> {
                    this.text = value;
                });
            }
            this.sb.append(this.text);
        }

        private String build() {
            return this.sb.toString();
        }
    }
}

