/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.ClickMethod;
import com.codeborne.selenide.ClickOptions;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.FluentCommand;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import com.codeborne.selenide.commands.DoubleClick;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.WebElementSource;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class AppiumDoubleClick
extends FluentCommand {
    private final DoubleClick defaultDoubleClick = new DoubleClick();

    protected void execute(WebElementSource locator, Object @Nullable [] args) {
        if (!AppiumDriverUnwrapper.isMobile(locator.driver())) {
            this.defaultDoubleClick.execute(locator, args);
            return;
        }
        Driver driver = locator.driver();
        WebElement webElement = this.findElement(locator);
        ClickOptions clickOptions = this.options(args);
        if (clickOptions.clickMethod() == ClickMethod.JS) {
            throw new UnsupportedOperationException("Click using JavaScript is not supported in mobile");
        }
        if (clickOptions.timeout() != null) {
            throw new UnsupportedOperationException("Click timeout is not supported in mobile");
        }
        driver.actions().doubleClick(webElement);
    }

    private ClickOptions options(Object @Nullable [] args) {
        return args == null || args.length == 0 ? ClickOptions.usingDefaultMethod() : (ClickOptions)Util.firstOf((Object[])args);
    }

    protected WebElement findElement(WebElementSource locator) {
        return locator.getWebElement();
    }
}

