/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.commands;

import com.codeborne.selenide.FluentCommand;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class HideKeyboard
extends FluentCommand {
    protected void execute(WebElementSource locator, Object @Nullable [] args) {
        Optional androidDriver = WebdriverUnwrapper.cast((SearchContext)locator.driver().getWebDriver(), AndroidDriver.class);
        Optional iosDriver = WebdriverUnwrapper.cast((SearchContext)locator.driver().getWebDriver(), IOSDriver.class);
        if (androidDriver.isPresent()) {
            this.hideKeyBoardForAndroid((AndroidDriver)androidDriver.get());
        } else if (iosDriver.isPresent()) {
            this.hideKeyBoardForIos((IOSDriver)iosDriver.get(), locator.getWebElement());
        } else {
            throw new UnsupportedOperationException("Cannot hide keyboard for webdriver " + locator.driver().getWebDriver());
        }
    }

    private void hideKeyBoardForAndroid(AndroidDriver driver) {
        if (driver.isKeyboardShown()) {
            driver.hideKeyboard();
        }
    }

    private void hideKeyBoardForIos(IOSDriver driver, WebElement element) {
        if (driver.isKeyboardShown()) {
            element.sendKeys(new CharSequence[]{"\n"});
        }
    }
}

