/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.appium.conditions.CombinedAttribute;
import com.codeborne.selenide.collections.ExactTexts;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class AppiumAttributeValues
extends ExactTexts {
    protected final CombinedAttribute attribute;

    public AppiumAttributeValues(CombinedAttribute attribute, String ... expectedAttributeValues) {
        super(expectedAttributeValues);
        this.attribute = attribute;
    }

    public AppiumAttributeValues(CombinedAttribute attribute, List<String> expectedAttributeValues) {
        super(expectedAttributeValues);
        this.attribute = attribute;
    }

    public CheckResult check(Driver driver, List<WebElement> elements) {
        List<@Nullable String> actualValues = this.getActualAttributes(driver, elements);
        if (actualValues.size() != this.expectedTexts.size()) {
            String message = String.format("List size mismatch (expected: %s, actual: %s)", this.expectedTexts.size(), actualValues.size());
            return CheckResult.rejected((String)message, actualValues);
        }
        for (int i = 0; i < this.expectedTexts.size(); ++i) {
            String actualAttributeValue;
            String expectedAttributeValue = (String)this.expectedTexts.get(i);
            if (Objects.equals(expectedAttributeValue, actualAttributeValue = actualValues.get(i))) continue;
            String message = String.format("Attribute #%s mismatch (expected: \"%s\", actual: \"%s\")", i, expectedAttributeValue, actualAttributeValue);
            return CheckResult.rejected((String)message, actualValues);
        }
        return new CheckResult(CheckResult.Verdict.ACCEPT, null);
    }

    private List<@Nullable String> getActualAttributes(Driver driver, List<WebElement> elements) {
        return elements.stream().map(element -> this.attribute.getAttributeValue(driver, (WebElement)element)).toList();
    }
}

