/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium.conditions;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.appium.AppiumDriverUnwrapper;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class CombinedAttribute {
    private final @Nullable String androidAttribute;
    private final @Nullable String iosAttribute;

    private CombinedAttribute(@Nullable String androidAttribute, @Nullable String iosAttribute) {
        this.androidAttribute = androidAttribute;
        this.iosAttribute = iosAttribute;
    }

    public static CombinedAttribute android(String android) {
        return new CombinedAttribute(android, null);
    }

    public CombinedAttribute ios(String ios) {
        return new CombinedAttribute(this.androidAttribute, ios);
    }

    public @Nullable String getAttributeValue(Driver driver, WebElement element) {
        return element.getAttribute(this.getAttributeName(driver));
    }

    private String getAttributeName(Driver driver) {
        if (AppiumDriverUnwrapper.isAndroid(driver)) {
            return Objects.requireNonNull(this.androidAttribute, "Android selector not given");
        }
        if (AppiumDriverUnwrapper.isIos(driver)) {
            return Objects.requireNonNull(this.iosAttribute, "iOS selector not given");
        }
        throw new UnsupportedOperationException("Unsupported webdriver: " + String.valueOf(WebDriverRunner.getWebDriver()));
    }
}

