/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.appium;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import com.codeborne.selenide.logevents.SelenideLogger;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.InteractsWithApps;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.android.appmanagement.AndroidTerminateApplicationOptions;
import io.appium.java_client.appmanagement.BaseTerminateApplicationOptions;
import java.time.Duration;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.SearchContext;

public class AppiumNavigator {
    public void launchApp(Supplier<Runnable> driverSupplier) {
        Configuration.browserSize = null;
        Configuration.pageLoadTimeout = -1L;
        SelenideLogger.run((String)"launch app", (String)"", (Runnable)driverSupplier.get());
    }

    public void activateApp(AppiumDriver driver, String appId) {
        SelenideLogger.run((String)"activate app", (String)appId, () -> WebdriverUnwrapper.cast((SearchContext)driver, InteractsWithApps.class).map(mobileDriver -> {
            mobileDriver.activateApp(appId);
            return true;
        }).orElseThrow(() -> new UnsupportedOperationException("Driver does not support app activation: " + String.valueOf(driver.getClass()))));
    }

    public void terminateApp(AppiumDriver driver, String appId, @Nullable Duration timeout) {
        SelenideLogger.run((String)"terminate app", (String)appId, () -> WebdriverUnwrapper.cast((SearchContext)driver, InteractsWithApps.class).map(mobileDriver -> {
            if (mobileDriver instanceof AndroidDriver) {
                AndroidDriver androidDriver = (AndroidDriver)mobileDriver;
                if (timeout != null) {
                    return androidDriver.terminateApp(appId, (BaseTerminateApplicationOptions)this.options(timeout));
                }
            }
            return mobileDriver.terminateApp(appId);
        }).orElseThrow(() -> new UnsupportedOperationException("Driver does not support app termination: " + String.valueOf(driver.getClass()))));
    }

    private AndroidTerminateApplicationOptions options(Duration timeout) {
        return new AndroidTerminateApplicationOptions().withTimeout(timeout);
    }
}

