/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.clearwithshortcut;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.clearwithshortcut.Platform;
import com.codeborne.selenide.commands.Clear;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearWithShortcut
extends Clear {
    private static final Logger log = LoggerFactory.getLogger(ClearWithShortcut.class);

    protected void clear(Driver driver, WebElement input) {
        input.clear();
        this.clearWithShortcut(driver, input);
    }

    protected void clearWithShortcut(Driver driver, WebElement input) {
        Platform platform = this.getPlatform(driver);
        if (!platform.isUnknown()) {
            try {
                CharSequence modifier = platform.modifierKey();
                driver.actions().sendKeys(input, new CharSequence[]{"0"}).keyDown(modifier).sendKeys(new CharSequence[]{"a"}).keyUp(modifier).sendKeys(new CharSequence[]{Keys.DELETE}).perform();
            }
            catch (WebDriverException failedToPressKeys) {
                log.error("Failed to clear the input with shortcut", (Throwable)failedToPressKeys);
            }
        }
    }

    protected Platform getPlatform(Driver driver) {
        if (!driver.supportsJavascript()) {
            return Platform.UNKNOWN;
        }
        try {
            String platform = (String)driver.executeJavaScript("return navigator.platform", new Object[0]);
            if (platform == null || platform.trim().isEmpty()) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Cannot detect platform: navigator.platform returned \"{}\"", (Object)platform);
            }
            return new Platform(platform);
        }
        catch (WebDriverException cannotExecuteJavascript) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("Cannot get navigator.platform", (Throwable)cannotExecuteJavascript);
            return Platform.UNKNOWN;
        }
    }
}

