/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.clearwithshortcut;

import java.util.Locale;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Keys;

public class Platform {
    public static final Platform UNKNOWN = new Platform("?");
    private final String platform;

    Platform(@Nullable String platform) {
        this.platform = platform == null || platform.trim().isEmpty() ? "?" : platform.trim().toLowerCase(Locale.ROOT);
    }

    boolean isUnknown() {
        return "?".equals(this.platform);
    }

    boolean isApple() {
        if (this.isUnknown()) {
            throw new IllegalStateException("Unknown platform");
        }
        return this.platform.contains("mac") || this.platform.contains("iphone");
    }

    public CharSequence modifierKey() {
        return this.isApple() ? Keys.COMMAND : Keys.CONTROL;
    }
}

