/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.fullscreenshot;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.Photographer;
import com.codeborne.selenide.impl.WebdriverPhotographer;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.chromium.HasCdp;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v116.page.Page;
import org.openqa.selenium.devtools.v116.page.model.Viewport;
import org.openqa.selenium.firefox.HasFullPageScreenshot;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class FullSizePhotographer
implements Photographer {
    private static final Logger log = LoggerFactory.getLogger(FullSizePhotographer.class);
    private static final JavaScript js = new JavaScript("get-screen-size.js");
    private final WebdriverPhotographer defaultImplementation;

    public FullSizePhotographer() {
        this(new WebdriverPhotographer());
    }

    protected FullSizePhotographer(WebdriverPhotographer defaultImplementation) {
        this.defaultImplementation = defaultImplementation;
    }

    @Nonnull
    @CheckReturnValue
    public <T> Optional<T> takeScreenshot(Driver driver, OutputType<T> outputType) {
        try {
            Optional result = this.takeFullSizeScreenshot(driver, outputType);
            return result.isPresent() ? result : this.defaultImplementation.takeScreenshot(driver, outputType);
        }
        catch (WebDriverException e) {
            log.error("Failed to take full-size screenshot", (Throwable)e);
            return this.defaultImplementation.takeScreenshot(driver, outputType);
        }
    }

    @Nonnull
    private <T> Optional<T> takeFullSizeScreenshot(Driver driver, OutputType<T> outputType) {
        WebDriver webDriver = this.unwrap(driver);
        if (webDriver instanceof HasFullPageScreenshot) {
            HasFullPageScreenshot firefoxDriver = (HasFullPageScreenshot)webDriver;
            return Optional.of(firefoxDriver.getFullPageScreenshotAs(outputType));
        }
        if (webDriver instanceof HasCdp) {
            return this.takeScreenshotWithCDP((WebDriver)((HasCdp)webDriver), outputType);
        }
        if (webDriver instanceof HasDevTools) {
            return this.takeScreenshot((WebDriver)((HasDevTools)webDriver), outputType);
        }
        return Optional.empty();
    }

    private WebDriver unwrap(Driver driver) {
        WebDriver webDriver = driver.getWebDriver();
        if (webDriver instanceof WrapsDriver) {
            WrapsDriver wrapper = (WrapsDriver)webDriver;
            webDriver = wrapper.getWrappedDriver();
        }
        if (webDriver instanceof RemoteWebDriver) {
            RemoteWebDriver remoteWebDriver = (RemoteWebDriver)webDriver;
            webDriver = new Augmenter().augment((WebDriver)remoteWebDriver);
        }
        return webDriver;
    }

    @Nonnull
    @CheckReturnValue
    private <WD extends WebDriver & HasDevTools, ResultType> Optional<ResultType> takeScreenshot(WD devtoolsDriver, OutputType<ResultType> outputType) {
        DevTools devTools = ((HasDevTools)devtoolsDriver).getDevTools();
        devTools.createSessionIfThereIsNotOne(devtoolsDriver.getWindowHandle());
        Options options = this.getOptions(devtoolsDriver);
        Viewport viewport = new Viewport((Number)0, (Number)0, (Number)options.fullWidth(), (Number)options.fullHeight(), (Number)1);
        String base64 = (String)devTools.send(Page.captureScreenshot(Optional.empty(), Optional.empty(), Optional.of(viewport), Optional.empty(), Optional.of(options.exceedViewport()), Optional.of(true)));
        Object screenshot = outputType.convertFromBase64Png(base64);
        return Optional.of(screenshot);
    }

    @Nonnull
    @CheckReturnValue
    private <WD extends WebDriver & HasCdp, ResultType> Optional<ResultType> takeScreenshotWithCDP(WD cdpDriver, OutputType<ResultType> outputType) {
        Options options = this.getOptions(cdpDriver);
        ImmutableMap captureScreenshotOptions = ImmutableMap.of((Object)"clip", (Object)ImmutableMap.of((Object)"x", (Object)0, (Object)"y", (Object)0, (Object)"width", (Object)options.fullWidth(), (Object)"height", (Object)options.fullHeight(), (Object)"scale", (Object)1), (Object)"captureBeyondViewport", (Object)options.exceedViewport());
        Map result = ((HasCdp)cdpDriver).executeCdpCommand("Page.captureScreenshot", (Map)captureScreenshotOptions);
        String base64 = (String)result.get("data");
        Object screenshot = outputType.convertFromBase64Png(base64);
        return Optional.of(screenshot);
    }

    private Options getOptions(WebDriver webDriver) {
        Map size = (Map)js.execute((SearchContext)webDriver, new Object[0]);
        return new Options((Long)size.get("fullWidth"), (Long)size.get("fullHeight"), (Boolean)size.get("exceedViewport"));
    }

    private static final class Options {
        private final long fullWidth;
        private final long fullHeight;
        private final boolean exceedViewport;

        private Options(long fullWidth, long fullHeight, boolean exceedViewport) {
            this.fullWidth = fullWidth;
            this.fullHeight = fullHeight;
            this.exceedViewport = exceedViewport;
        }

        public String toString() {
            return "Options[" + "fullWidth=" + this.fullWidth + "," + "fullHeight=" + this.fullHeight + "," + "exceedViewport=" + this.exceedViewport + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (int)(this.fullWidth ^ this.fullWidth >>> 32);
            result = 31 * result + (int)(this.fullHeight ^ this.fullHeight >>> 32);
            result = 31 * result + (this.exceedViewport ? 1 : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((Options)arg0).fullWidth != this.fullWidth) {
                return false;
            }
            if (((Options)arg0).fullHeight != this.fullHeight) {
                return false;
            }
            return ((Options)arg0).exceedViewport == this.exceedViewport;
            {
            }
        }

        public long fullWidth() {
            return this.fullWidth;
        }

        public long fullHeight() {
            return this.fullHeight;
        }

        public boolean exceedViewport() {
            return this.exceedViewport;
        }
    }
}

