/*
 * Decompiled with CFR 0.152.
 */
package org.selenide.grid;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.FileNotDownloadedError;
import com.codeborne.selenide.impl.Downloader;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GridDownloader {
    private static final Logger log = LoggerFactory.getLogger(GridDownloader.class);

    GridDownloader() {
    }

    @Nonnull
    static File archiveFile(Downloader downloader, Driver driver, File downloadedFile) {
        RemoteWebDriver webDriver = WebdriverUnwrapper.unwrapRemoteWebDriver((WebDriver)driver.getWebDriver());
        File uniqueFolder = downloader.prepareTargetFolder(driver.config());
        try {
            webDriver.downloadFile(downloadedFile.getName(), uniqueFolder.toPath());
            File localFile = new File(uniqueFolder, downloadedFile.getName());
            log.debug("Copied the downloaded file {} from Grid to {}", (Object)downloadedFile, (Object)localFile);
            return localFile;
        }
        catch (IOException e) {
            throw new FileNotDownloadedError(driver, "Failed to copy downloaded file from grid", driver.config().timeout(), (Exception)e);
        }
    }
}

