/*
 * Decompiled with CFR 0.152.
 */
package org.selenide.grid;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.impl.WebdriverUnwrapper;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class GridDownloadsFolder
implements DownloadsFolder {
    private final RemoteWebDriver webDriver;
    private final Config config;

    public GridDownloadsFolder(Driver driver) {
        this.config = driver.config();
        this.webDriver = WebdriverUnwrapper.unwrapRemoteWebDriver((WebDriver)driver.getWebDriver());
    }

    public void cleanupBeforeDownload() {
        this.webDriver.deleteDownloadableFiles();
    }

    public void deleteIfEmpty() {
    }

    @Nonnull
    @CheckReturnValue
    public List<File> files() {
        return this.webDriver.getDownloadableFiles().stream().map(name -> new File((String)name)).collect(Collectors.toList());
    }

    @Nonnull
    @CheckReturnValue
    public List<DownloadedFile> filesNewerThan(long modifiedAfterTs) {
        return this.files().stream().map(file -> new DownloadedFile(file, Collections.emptyMap())).collect(Collectors.toList());
    }

    @Nonnull
    public String getPath() {
        return this.config.downloadsFolder();
    }

    public String toString() {
        return "GridDownloadsFolder{" + this.getPath() + "}";
    }
}

