/*
 * Decompiled with CFR 0.152.
 */
package org.selenide.grid;

import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.DownloadFileToFolder;
import com.codeborne.selenide.impl.Downloader;
import java.io.File;
import org.jspecify.annotations.Nullable;
import org.selenide.grid.GridDownloader;
import org.selenide.grid.GridDownloadsFolder;

public class DownloadFileFromGridToFolder
extends DownloadFileToFolder {
    private final Downloader downloader;

    public DownloadFileFromGridToFolder() {
        this(new Downloader());
    }

    DownloadFileFromGridToFolder(Downloader downloader) {
        this.downloader = downloader;
    }

    protected @Nullable DownloadsFolder getDownloadsFolder(Driver driver) {
        return driver.isLocalBrowser() ? super.getDownloadsFolder(driver) : new GridDownloadsFolder(driver);
    }

    protected void waitWhileFilesAreBeingModified(Driver driver, DownloadsFolder folder, long timeout, long pollingInterval) {
        if (driver.isLocalBrowser()) {
            super.waitWhileFilesAreBeingModified(driver, folder, timeout, pollingInterval);
        }
    }

    protected void failFastIfNoChanges(Driver driver, DownloadsFolder folder, FileFilter filter, long start, long timeout, long incrementTimeout) {
        if (driver.isLocalBrowser()) {
            super.failFastIfNoChanges(driver, folder, filter, start, timeout, incrementTimeout);
        }
    }

    protected File archiveFile(Driver driver, File downloadedFile) {
        if (driver.isLocalBrowser()) {
            return super.archiveFile(driver, downloadedFile);
        }
        return GridDownloader.archiveFile(this.downloader, driver, downloadedFile);
    }
}

