/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit;

import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.codeborne.selenide.logevents.SoftAssertsErrorsCollector;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@ParametersAreNonnullByDefault
public class SoftAsserts
extends ExternalResource {
    private Description currentTest;
    private final boolean fullStacktraces;

    public SoftAsserts() {
        this(true);
    }

    public SoftAsserts(boolean fullStacktraces) {
        this.fullStacktraces = fullStacktraces;
    }

    public Statement apply(Statement base, Description description) {
        this.currentTest = description;
        return super.apply(base, description);
    }

    protected void before() {
        SelenideLogger.addListener((String)"softAssert", (LogEventListener)new SoftAssertsErrorsCollector());
    }

    protected void after() {
        ErrorsCollector errorsCollector = Objects.requireNonNull((ErrorsCollector)SelenideLogger.removeListener((String)"softAssert"));
        errorsCollector.cleanAndThrowAssertionError(this.currentTest.getDisplayName(), null, this.fullStacktraces);
    }
}

