/*
 * Decompiled with CFR 0.152.
 */
package org.selenide.selenoid;

import com.codeborne.selenide.Driver;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelenoidClient {
    private static final Logger log = LoggerFactory.getLogger(SelenoidClient.class);
    private static final ObjectMapper json = new ObjectMapper();
    final String baseUrl;
    private final String sessionId;

    public static SelenoidClient clientFor(Driver driver) {
        String hubUrl = Objects.requireNonNull(driver.config().remote(), "Remote browser URL is not configured");
        return new SelenoidClient(hubUrl, driver.getSessionId().toString());
    }

    public SelenoidClient(String hubUrl, String sessionId) {
        this.baseUrl = hubUrl.replace("/wd/hub", "");
        this.sessionId = sessionId;
    }

    public List<String> downloads() {
        URL url = this.url(this.baseUrl + "/download/" + this.sessionId + "/?json");
        String fileNamesJson = this.readToString(url);
        List<String> fileNames = this.parseJson(fileNamesJson);
        log.debug("Retrieved files from {}: {}", (Object)url, fileNames);
        return fileNames;
    }

    List<String> parseJson(String fileNamesJson) {
        try {
            return (List)json.readerForListOf(String.class).readValue(fileNamesJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to parse Selenoid response: " + fileNamesJson, e);
        }
    }

    public File download(String fileName, File targetFolder) {
        File file;
        block15: {
            URL url = this.urlOfDownloadedFile(fileName);
            InputStream in = this.connectionFromUrl(url).getInputStream();
            try {
                File file2 = new File(targetFolder, fileName);
                try (OutputStream out = Files.newOutputStream(file2.toPath(), new OpenOption[0]);){
                    IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                }
                log.debug("Downloaded file from {} to {}", (Object)url, (Object)file2.getAbsolutePath());
                file = file2;
                if (in == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to download file " + String.valueOf(url), e);
                }
            }
            in.close();
        }
        return file;
    }

    public void deleteDownloadedFiles() {
        log.debug("Deleting downloaded files...");
        List<String> downloadedFiles = this.downloads();
        downloadedFiles.forEach(this::deleteDownloadedFile);
        log.debug("Deleted {} downloaded files", (Object)downloadedFiles.size());
    }

    public void deleteDownloadedFile(String fileName) {
        URL url = this.urlOfDownloadedFile(fileName);
        try {
            HttpURLConnection connection = this.connectionFromUrl(url);
            connection.setRequestMethod("DELETE");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new RuntimeException("Failed to delete downloaded file " + fileName + ", received http status " + responseCode);
            }
            log.debug("Deleted downloaded file {}", (Object)url);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete downloaded file " + String.valueOf(url), e);
        }
    }

    public String getClipboardText() {
        String string;
        block9: {
            HttpURLConnection connection = this.connectionFromUrl(this.url(this.baseUrl, "clipboard", this.sessionId));
            int code = connection.getResponseCode();
            if (code != 200) {
                throw new RuntimeException("Something went wrong while getting clipboard! Response code: " + code);
            }
            InputStream in = connection.getInputStream();
            try {
                string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Something went wrong while getting clipboard!", e);
                }
            }
            in.close();
        }
        return string;
    }

    public void setClipboardText(String text) {
        try {
            HttpURLConnection connection = this.connectionFromUrl(this.url(this.baseUrl, "clipboard", this.sessionId));
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setConnectTimeout(10000);
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);){
                writer.write(text);
            }
            int code = connection.getResponseCode();
            if (code != 200) {
                throw new RuntimeException("Something went wrong while writing clipboard! Response code: " + code);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't set clipboard content! ", e);
        }
    }

    URL urlOfDownloadedFile(String fileName) {
        if (!fileName.equals(FilenameUtils.normalize((String)FilenameUtils.getName((String)fileName)))) {
            throw new IllegalArgumentException("Invalid file name: " + fileName);
        }
        return this.url(this.baseUrl, "download", this.sessionId, fileName);
    }

    private URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to build valid URL from " + url, e);
        }
    }

    private URL url(String base, String ... pathSegments) {
        try {
            return new URIBuilder(base).setPathSegments(pathSegments).build().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Failed to build valid URL from " + base + "+" + Arrays.toString(pathSegments), e);
        }
    }

    private String readToString(URL url) {
        String string;
        block8: {
            InputStream in = this.connectionFromUrl(url).getInputStream();
            try {
                string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to fetch data from " + String.valueOf(url), e);
                }
            }
            in.close();
        }
        return string;
    }

    private HttpURLConnection connectionFromUrl(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (url.getUserInfo() != null) {
            String basicAuth = "Basic " + new String(Base64.getEncoder().encode(url.getUserInfo().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            connection.setRequestProperty("Authorization", basicAuth);
        }
        return connection;
    }

    public String toString() {
        return "SelenoidClient{" + this.sessionId + "}";
    }
}

