/*
 * Decompiled with CFR 0.152.
 */
package org.selenide.selenoid;

import com.codeborne.selenide.DefaultClipboard;
import com.codeborne.selenide.Driver;
import org.selenide.selenoid.SelenoidClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelenoidClipboard
extends DefaultClipboard {
    private static final Logger log = LoggerFactory.getLogger(SelenoidClipboard.class);

    public SelenoidClipboard(Driver driver) {
        super(driver);
    }

    public String getText() {
        if (this.isLocalWebdriver()) {
            log.debug("Working in local browser. Switching to a default Clipboard implementation.");
            return super.getText();
        }
        return SelenoidClient.clientFor(this.driver()).getClipboardText();
    }

    public void setText(String text) {
        if (this.isLocalWebdriver()) {
            log.debug("Working in local browser. Switching to a default Clipboard implementation.");
            super.setText(text);
        } else {
            SelenoidClient.clientFor(this.driver()).setClipboardText(text);
        }
    }

    private boolean isLocalWebdriver() {
        return this.driver().config().remote() == null;
    }
}

