/*
 * Decompiled with CFR 0.152.
 */
package org.selenide.selenoid;

import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.files.DownloadedFile;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.selenide.selenoid.SelenoidClient;

public class SelenoidDownloadsFolder
implements DownloadsFolder {
    private final SelenoidClient selenoidClient;

    public SelenoidDownloadsFolder(Driver driver) {
        this.selenoidClient = SelenoidClient.clientFor(driver);
    }

    public void cleanupBeforeDownload() {
        this.selenoidClient.deleteDownloadedFiles();
    }

    public void deleteIfEmpty() {
    }

    public List<File> files() {
        List<String> files = this.selenoidClient.downloads();
        return files.stream().map(name -> new File((String)name)).collect(Collectors.toList());
    }

    public List<DownloadedFile> filesNewerThan(long modifiedAfterTs) {
        return this.files().stream().map(file -> new DownloadedFile(file, Collections.emptyMap())).collect(Collectors.toList());
    }

    public String toString() {
        return this.selenoidClient.toString();
    }

    public String getPath() {
        return "/tmp/not/really/used";
    }
}

